# #
# $Date: 1995/01/14 18:26:35 $  $Author: frankp $   $Revision: 1.12 $ #
# #
# frankp, 29/07/94 #

#++
    crossmul.mu

    linalg::crossProduct(u,v) 

    u,v: vectors of length 3

    Returns the vector cross product of u and v where u and v are
    vectors over the same coeffRing, each with three elements.

++#

linalg::crossProduct := proc(u,v)
    name linalg::crossProduct;
begin
    if testargs() then
        if args(0) <> 2 then error("wrong no of args") end_if;
	if not testtype( u,linalg::VectorOf(Type::AnyType,3) ) then
	    error("expecting vectors of dimension 3")
	end_if;
	if not testtype( v,linalg::VectorOf(u::coeffRing,3) ) then
	    error("vectors are not compatibel")
	end_if
    end_if;

    u::newThis( op(u::dimen(u)),
	[u[2]*v[3] - u[3]*v[2], u[3]*v[1] - u[1]*v[3], u[1]*v[2] - u[2]*v[1]]
    )
end_proc:
