# #
# $Date: 1995/05/09 10:21:59 $  $Author: frankp $   $Revision: 1.19 $ #
# #
# frankp, 16/08/94 #

#++
  charmat.mu

	linalg::charMatrix  --  return the characteristic matrix

	linalg::charMatrix(A,x)
	
	A: square matrix over a commutative ring
	x: valid polynomial indeterminate
	 
	This function constructs the characteristic matrix, defined
	by x*E(n) - A, where 'E(n)' is the identity matrix of 
	dimension n=dimen(A).
	The characteristic matrix is defined over the domain 
	'DistributedPolynomial(R)' when the coefficient domain R
	og A has the axiom 'normalRep', and 'Polynomial(A::coeffRing)'
	otherwise. 
	R must be a commutative ring.

	Note: Evaluations of the characteristic matrix C for a matrix
	      A of matrix domain M for special values u of x can be 
	      done by

		   M::map( C,evalp,x=u )
++#

linalg::charMatrix := proc(A,x)
    name linalg::charMatrix;
    local t, S;
begin
    if testargs() then
        if args(0) <> 2 then error("wrong no of args") end_if;
	if A::hasProp( MatrixCat ) <> TRUE then
	    error("expecting a matrix")
	end_if;
	if not (A::coeffRing)::hasProp( CommutativeRing ) then
	    error("expecting matrix over a commutative ring")
	end_if;
	t := A::dimen(A);
	if op(t,1) <> op(t,2) then
	    error("expecting a square matrix")
	end_if:
	if poly(x) = FAIL then
	    error("illegal indeterminate")
	end_if
    end_if;

    S := A::coeffRing;
    if S::hasProp( normalRep ) then S := DistributedPolynomial( [x],S )
    else S := Polynomial( S )
    end_if;
    A := domattr(Matrix(S),"convert")( A );
    if A = FAIL then
	error("unable to convert matrix to a matrix over ".expr2text(S))
    end_if;

    A::_plus( A::newThis(op(A::dimen(A)),S(x),Diagonal),A::negate(A) )
end_proc:

# end of file #
