# #
# $Date: 1995/05/31 18:49:51 $  $Author: frankp $   $Revision: 1.13 $ #
# #
# frankp, 16/08/94 #

#++
  adjoint.mu

	linalg::adjoint(A) -- return the adjoint of the square matrix A

	Computes the adjoint of a matrix over a commutative ring.
	This is the matrix whose (i,j)-th entry is the (j,i)-th
	cofactor of A.

	The (j,i)-th cofactor of A is defined by 

	    A'(i,j) = (-1)^(i+j)*det(A(i,j))

	where A(i,j) is the submatrix of A obtained from A by
	deleting the i-th row and j-th column.
++#

linalg::adjoint := proc(A)
    name linalg::adjoint;
    local n, R, i, j, a, det, Ai, delRow, delCol, Rnegate;
begin
    if testargs() then
        if args(0) <> 1 then error("wrong no of args") end_if;
	if A::hasProp( MatrixCat ) <> TRUE then
	    error("expecting a matrix")
	end_if;
	if not (A::coeffRing)::hasProp( CommutativeRing ) then
	    error("expecting matrix over a commutative ring")
	end_if;
	n := A::dimen(A);
	if op(n,1) <> op(n,2) then error("expecting a square matrix") end_if
    end_if;

    det := linalg::det;
    delRow := A::delRow;
    delCol := A::delCol;
    
    R := A::coeffRing;
    Rnegate := R::negate;

    n := op( A::dimen(A),1 );
    a := array( 1..n,1..n );
    for i from 1 to n do
	Ai := delCol( A,i );
	for j from 1 to n do
	    a[i,j] := det(delRow( Ai,j ));
	    if i+j mod 2 = 1 then
		a[i,j] := Rnegate( a[i,j] )
	    end_if
	end_for
    end_for;

    A::newThis( a ) 
end_proc:

# end of file #
