# #
# $Date: 1995/07/17 06:34:53 $  $Author: frankp $   $Revision: 1.12.2.1 $ #
# #
# frankp, 16/08/94 #

#++
  addcol.mu

	linalg::addCol() -- form linear combinations of matrix columns

	addCol(A,p1,p2,s)

	A     : matrix, square matrix
	p1,p2 : positive integers
	s     : any

	After s is converted into an element of A::coeffRing, 
	'addCol' returns a copy of matrix A in which column 
	p2 of A is replaced by col(A,p1)*s + col(A,p2).
++#

linalg::addCol := proc(A,p1,p2,s)
    name linalg::addCol;
    local R, sR, r;
begin
    if testargs() then
	if args(0) <> 4 then error("wrong no of args") end_if;
	if A::hasProp( MatrixCat ) <> TRUE then
	    error ("expecting a matrix")
	end_if;
	if not testtype( p1,Type::PosInt )
	or not testtype( p2,Type::PosInt )
	then
	    error("invalid indices")
	end_if;
	R := op( A::dimen(A),2 );
	if p1 > R or p2 > R then
	    error("indices larger than upper matrix bound")
	end_if;
	if not testtype( s,A::coeffRing ) then
	    error("unable to convert ".expr2text(s))
	end_if
    end_if;

    R := A::coeffRing;
    if domtype(s) <> R then
	sR := R::convert( s );
        if sR = FAIL then sR := s::convert_to( s,R ) end_if
    end_if;

    r := A::col( A,p1 );
    A::setCol( A,p2,_plus(A::map(r,R::_mult,sR),A::col( A,p2 )) )
end_proc:

# end of file #
