# $Date: 1995/05/04 11:32:01 $ $Author: kg $ $Revision: 1.17 $ #

# kg, 13/01/94 #

#--
specfunc.mu -- define/load special functions
--#

proc()
    local path, mkfloat;
begin

path:= pathname("SPECFUNC"):

# mkfloat -- changes the FUNC_ENV named f such that its 2nd operand and its
	"type" attribute is from fenv and its "float" attribute is constructed
	from the 1st operand of fenv. #

mkfloat:= proc(f, fenv)
    local o, t;
begin
    o:= op(fenv,2);
    t:= funcattr(fenv,"type");

    # create "float" attribute #
    fenv:= subsop(float_gen, 5=op(fenv,1), 3="".f);

    # insert "float" and "type" attribute,
      let op(fenv,2) be the 2nd operand of f #
    subsop(hold((f:=subsop(funcattr(funcattr(f,"float",fenv),"type",t),2=o))),
	1=f, [2,1,1,1]=level(f), [2,1,1,3]=fenv, [2,1,3]=t, [2,2,2]=o);
    eval(%);
end_proc:

# define special functions which are evaluated numerically by system
  functions #

sin:= loadproc(sin, path, "sin", mkfloat, hold(sin), stdlib::sin):
cos:= loadproc(cos, path, "cos", mkfloat, hold(cos), stdlib::cos):
tan:= loadproc(tan, path, "tan", mkfloat, hold(tan), stdlib::tan):
asin:= loadproc(asin, path, "asin", mkfloat, hold(asin), stdlib::asin):
acos:= loadproc(acos, path, "acos", mkfloat, hold(acos), stdlib::acos):
atan:= loadproc(atan, path, "atan", mkfloat, hold(atan), stdlib::atan):
sinh:= loadproc(sinh, path, "sinh", mkfloat, hold(sinh), stdlib::sinh):
cosh:= loadproc(cosh, path, "cosh", mkfloat, hold(cosh), stdlib::cosh):
tanh:= loadproc(tanh, path, "tanh", mkfloat, hold(tanh), stdlib::tanh):
asinh:= loadproc(asinh, path, "asinh", mkfloat, hold(asinh), stdlib::asinh):
acosh:= loadproc(acosh, path, "acosh", mkfloat, hold(acosh), stdlib::acosh):
atanh:= loadproc(atanh, path, "atanh", mkfloat, hold(atanh), stdlib::atanh):
exp:= loadproc(exp, path, "exp" , mkfloat, hold(exp), stdlib::exp):
ln:= loadproc(ln, path, "ln", mkfloat, hold(ln), stdlib::ln):
sqrt:= loadproc(sqrt, path, "sqrt", mkfloat, hold(sqrt), stdlib::sqrt):
gamma:= loadproc(gamma, path, "gamma", mkfloat, hold(gamma), stdlib::gamma):
igamma:= loadproc(igamma,path, "igamma",mkfloat, hold(igamma), stdlib::igamma):
zeta:= loadproc(zeta, path, "zeta", mkfloat, hold(zeta), stdlib::zeta):
erfc:=loadproc(erfc, path, "erfc", mkfloat, hold(erfc), stdlib::erfc):
eint:= loadproc(eint, path, "eint", mkfloat, hold(eint), stdlib::eint):
psi:= loadproc(psi, path, "psi", mkfloat, hold(psi), stdlib::psi):

cot:= loadproc(cot, path, "cot"):
csc:= loadproc(csc, path, "csc"):
sec:= loadproc(sec, path, "sec"):
acot:= loadproc(acot, path, "acot"):
asec:= loadproc(asec, path, "asec"):
acsc:= loadproc(acsc, path, "acsc"):
coth:= loadproc(coth, path, "coth"):
csch:= loadproc(csch, path, "csch"):
sech:= loadproc(sech, path, "sech"):
acoth:= loadproc(acoth, path, "acoth"):
acsch:= loadproc(acsch, path, "acsch"):
asech:= loadproc(asech, path, "asech"):
besselJ:= loadproc(besselJ, path, "besselJ"):
besselY:= loadproc(besselY, path, "besselY"):
erf:= loadproc(erf, path, "erf"):
sign:= loadproc(sign, path, "sign"):
abs:= loadproc(abs, path, "abs"):
fact:= loadproc(fact, path, "fact"):

end_proc():

# end of file #
