# $Date: 1995/04/04 15:54:42 $  $Author: kg $   $Revision: 1.7 $ #

# numlib.mu -- functions for elementary number theory #
# fritz, 16/09/94 #

#++
User functions:

decimal          - returns a infinite representation of a rational
divisors         - returns the list of divisors of an integer
fibonacci        - calculates Fibonacci numbers
fromAscii        - decodes a list of ASCII-codes
g_adic           - calculates g-adic representations
ichrem           - generalized Chinese remainder algorithm
igcdmult         - extended Euclidean algorithm
isquadres        - checks if a number is a quadratic residue
issqr            - checks if an integer is a square
jacobi           - Jacobi symbol
lambda           - the Carmichael function
legendre         - Legendre symbol
lincongruence    - solves linear congruences
mersenne         - returns the primes p such that M(p) is a prime
moebius          - the Moebius mu-function
mroots           - calculates modular roots of univariate polynomials
msqrts           - calculates square roots of quadratic residues
numdivisors      - returns number of divisors
numprimedivisors - returns number of primedivisors
order            - calculates orders in the group of units modulo m
pollard          - factors an integer using Pollard's rho method
prevprime        - returns the previous prime
prime            - returns the ith prime [extends ithprime]
primedivisors    - returns list of primedivisors
primroot         - returns a primitive root
proveprime	 - primality proving using elliptic curves
sigma            - returns the sum of kth powers of the divisors
sumdivisors      - returns the sum of the divisors
tau              - returns number of divisors
toAscii          - encodes a string as a list of ASCII-codes 

++#

proc()
  local path;
begin
  numlib := domain():
  numlib::name := "numlib":
  numlib::info := "Library 'numlib': \
    the package for elementary number theory":
  numlib::interface := {
  hold(decimal),
  hold(divisors),
	hold(fibonacci),
	hold(fromAscii),
	hold(g_adic),
	hold(ichrem),
	hold(igcdmult),
	hold(isquadres),
	hold(issqr),
	hold(jacobi),
	hold(lambda),
	hold(legendre),
	hold(lincongruence),
	hold(mersenne),
	hold(moebius),
	hold(mroots),
	hold(msqrts),
	hold(numdivisors),
	hold(numprimedivisors),
	hold(order),
	hold(pollard),
	hold(prevprime),
	hold(prime),
	hold(primedivisors),
	hold(primroot),
        hold(proveprime),
	hold(sigma),
	hold(sumdivisors),
	hold(tau),
	hold(toAscii)
	}:
  
  path := pathname("NUMLIB"):

numlib::decimal:= loadproc(numlib::decimal, path, "decimal"):
numlib::divisors:= loadproc(numlib::divisors, path, "divisors"):
numlib::fibonacci:= loadproc(numlib::fibonacci, path, "fibonacc"):
numlib::fromAscii:= loadproc(numlib::fromAscii, path, "fromAsc");
numlib::fromAscii:= loadproc(numlib::fromAscii, path, "fromAsc"):
numlib::g_adic:= loadproc(numlib::g_adic, path, "g_adic"):
numlib::ichrem:= loadproc(numlib::ichrem, path, "ichrem"):
numlib::igcdmult:= loadproc(numlib::igcdmult, path, "igcdmult"):
numlib::isquadres:= loadproc(numlib::isquadres, path, "isqdres"):
numlib::issqr:= loadproc(numlib::issqr, path, "issqr"):
numlib::jacobi:= loadproc(numlib::jacobi, path, "jacobi"):
numlib::lambda:= loadproc(numlib::lambda, path, "lambda"):
numlib::legendre:= loadproc(numlib::legendre, path, "legendre"):
numlib::lincongruence:= loadproc(numlib::lincongruence, path, "lincongr"):
numlib::mersenne:= loadproc(numlib::mersenne, path, "mersenne"):
numlib::moebius:= loadproc(numlib::moebius, path, "moebius"):
numlib::mroots:= loadproc(numlib::mroots, path, "mroots"):
numlib::msqrts:= loadproc(numlib::msqrts, path, "msqrts"):
numlib::numdivisors:= loadproc(numlib::numdivisors, path, "numdivs"):
numlib::numprimedivisors:= loadproc(numlib::numprimedivisors, path, "numpdivs"):
numlib::order:= loadproc(numlib::order, path, "order"):
numlib::prevprime:= loadproc(numlib::prevprime, path, "prevprim"):
numlib::prime:= loadproc(numlib::prime, path, "prime"):
numlib::primedivisors:= loadproc(numlib::primedivisors, path, "primdivs"):
numlib::primroot:= loadproc(numlib::primroot, path, "primroot"):
numlib::proveprime:= loadproc(numlib::proveprime, path, "prfprime"):
numlib::sigma:= loadproc(numlib::sigma, path, "sigma"):
numlib::sumdivisors:= loadproc(numlib::sumdivisors, path, "sumdivs"):
numlib::tau:= loadproc(numlib::tau, path, "tau"):
numlib::toAscii:= loadproc(numlib::toAscii, path, "toAscii"):
numlib::pollard:= loadproc(numlib::pollard, path, "pollard"):

# functions without interface: #

# for msqrts: #
numlib::hensel2:= loadproc(numlib::hensel2, path, "hensel2"):
numlib::ressol2:= loadproc(numlib::ressol2, path, "ressol2"):

# for mroots: #
numlib::mrootsPP:= loadproc(numlib::mrootsPP, path, "mrootsPP"):
numlib::regularHensel:= loadproc(numlib::regularHensel, path, "hensel"):
numlib::singularHensel:= loadproc(numlib::singularHensel, path, "hensel"):
  null():
end_proc():


