# $Date: 1995/03/01 16:55:33 $ $Author: kg $ $Revision: 1.7 $ #

# andi, 15/12/94 #

# module.mu -- the 'module' library for module management #

#++
User Functions:

load     - load module (refer to 'loadmod')
unload   - unload module (refer to 'loadmod')
func     - create DOM_FUNC_ENV of a mod.-func. (refer to 'external')

age      - get/set maximum age for loaded modules (module-aging)
max      - get/set maximum number of simultaneously loaded modules
stat     - prints out the state of module management
which    - get fullname (path) of a module

clean    - remove recursions in module domains
++#

proc()
    local path;
begin

module:= domain():

module::name:= "module":
module::info:= "Library 'module': Utilities for module management":
module::interface:= {	hold(func), hold(load), hold(unload), 
			hold(age),  hold(help), hold(max), 
			hold(stat), hold(which)
}:

path:= pathname("MODULE"):

module::load:= loadproc(module::load, path,"load"):
module::unload:= loadproc(module::unload, path,"unload"):
module::func:= loadproc(module::func, path,"func"):

module::age:= loadproc(module::age, path,"age"):
module::help:= loadproc(module::help, path,"help"):
module::max:= loadproc(module::max, path,"max"):
module::stat:= loadproc(module::stat, path,"stat"):
module::which:= loadproc(module::which, path,"which"):

module::clean:= loadproc(module::clean, path,"clean"):

module::expr2text:= loadproc(module::expr2text, path,"expr2text"):

module::new:= proc()
begin
	if  ( args(0) = 2 ) then
		module::func( args() );
	elif( args(0) = 1 ) then
		module::load( args() );
	else
		error( "Wrong number of arguments" );
	end_if;
end_proc:

end_proc():

# end of file #
