# $Date: 1995/05/17 15:58:41 $ $Author: kg $ $Revision: 1.21 $ #
#++
domains -- a library for constructing domains and categories
++#

proc()
local path;
begin

domains:= domain():
domains::name:= "domains":
domains::info:= "Library 'domains': Constructing domains and categories":
domains::interface:= { hold(show_type) }:
domains::SHOW_TYPE:= FALSE:

domains::show_type:= fun((
    if domtype(args(1)) <> DOM_BOOL then error("illegal argument") end_if;
    domains::SHOW_TYPE:= args(1)
)):

# basic domains #

path := pathname("DOMAINS", "CONSTR");

DomainConstructor:= loadproc(DomainConstructor, path, "DomCons"):
Category:= loadproc(Category, path, "Category"):
CategoryConstructor:= loadproc(CategoryConstructor, path, "CatCons"):
Axiom:= loadproc(Axiom, path, "Axiom"):
AxiomConstructor:= loadproc(AxiomConstructor, path, "AxCons"):

# axioms #

path := pathname("DOMAINS", "AXIOM");

canonicalRep:= loadproc(canonicalRep, path, "canonRep"):
canonicalOrder:= loadproc(canonicalOrder, path, "canonOrd"):
systemRep:= loadproc(systemRep, path, "sysRep"):
normalRep:= loadproc(normalRep, path, "normForm"):
noZeroDivisors:= loadproc(noZeroDivisors, path, "noZerDiv"):
canonicalUnitNormal:= loadproc(canonicalUnitNormal, path, "canUNorm"):
closedUnitNormals:= loadproc(closedUnitNormals, path, "clUNorm"):

# categories #

path := pathname("DOMAINS", "CATEGORY");

domains::repeatedSquaring:= loadproc(domains::repeatedSquaring, path, "rep_sq"):

SetCat:= loadproc(SetCat, path, "SetCat"):
OrderedSet:= loadproc(OrderedSet, path, "OrdSet"):
FiniteCollectionCat:= loadproc(FiniteCollectionCat, path, "FinCollC"):
HomogeneousFiniteCollectionCat:= loadproc(HomogeneousFiniteCollectionCat, path, "HFinColC"):
SemiGroup:= loadproc(SemiGroup, path, "SemiGrp"):
Monoid:= loadproc(Monoid, path, "Monoid"):
Group:= loadproc(Group, path, "Group"):
AbelianSemiGroup:= loadproc(AbelianSemiGroup, path, "AbSemGrp"):
AbelianMonoid:= loadproc(AbelianMonoid, path, "AbMonoid"):
CancellationAbelianMonoid:= loadproc(CancellationAbelianMonoid, path, "CanAbMon"):
AbelianGroup:= loadproc(AbelianGroup, path, "AbGroup"):
Rng:= loadproc(Rng, path, "Rng"):
LeftModule:= loadproc(LeftModule, path, "LeftMod"):
RightModule:= loadproc(RightModule, path, "RightMod"):
Ring:= loadproc(Ring, path, "Ring"):
EntireRing:= loadproc(EntireRing, path, "EntRing"):
CommutativeRing:= loadproc(CommutativeRing, path, "CommRing"):
Module:= loadproc(Module, path, "Module"):
Algebra:= loadproc(Algebra, path, "Algebra"):
PartialDifferentialRing:= loadproc(PartialDifferentialRing, path, "PDiffRng"):
DifferentialRing:= loadproc(DifferentialRing, path, "DiffRing"):
IntegralDomain:= loadproc(IntegralDomain, path, "IntegDom"):
GcdDomain:= loadproc(GcdDomain, path, "GcdDom"):
FactorialDomain:= loadproc(FactorialDomain, path, "FactDom"):
PrincipalIdealDomain:= loadproc(PrincipalIdealDomain, path, "PrIdDom"):
EuclideanDomain:= loadproc(EuclideanDomain, path, "EuclDom"):
SkewField:= loadproc(SkewField, path, "SkewFld"):
HomogeneousFiniteProductCat:= loadproc(HomogeneousFiniteProductCat, path, "HFiProdC"):
Field:= loadproc(Field, path, "Field"):
QuotientField:= loadproc(QuotientField, path, "QuoField"):
PolynomialCat:= loadproc(PolynomialCat, path, "PolyCat"):
UnivariatePolynomialCat:= loadproc(UnivariatePolynomialCat, path, "UPolyCat"):
MatrixCat:= loadproc(MatrixCat, path, "MatCat"):
SquareMatrixCat:= loadproc(SquareMatrixCat, path, "SqMatCat"):

# domains #

path := pathname("DOMAINS", "DOMAIN");

domains::extoper:= loadproc(domains::extoper, path, "extoper"):

BaseDomain:= loadproc(BaseDomain, path, "BaseDom"):
Expression:= loadproc(Expression, path, "Expr"):
ArithmeticalExpression:= loadproc(ArithmeticalExpression, path, "AritExpr"):
Numerical:= loadproc(Numerical, path, "Numeric"):
Float:= loadproc(Float, path, "Float"):
Rational:= loadproc(Rational, path, "Rational"):
Integer:= loadproc(Integer, path, "Integer"):
IntegerMod:= loadproc(IntegerMod, path, "IntMod"):
ExpressionField:= loadproc(ExpressionField, path, "ExprFld");
Fraction:= loadproc(Fraction, path, "Fraction");
Polynomial:= loadproc(Polynomial, path, "Polynom");
DistributedPolynomial:= loadproc(DistributedPolynomial, path, "DistPoly");
Product:= loadproc(Product, path, "Product"):
Matrix:= loadproc(Matrix, path, "Matrix"):
SquareMatrix:= loadproc(SquareMatrix, path, "SqMatrix"):
TruncatedPowerSeries:= loadproc(TruncatedPowerSeries, path, "TrPowSer"):
AlgebraicExtension:= loadproc(AlgebraicExtension, path, "AlgebExt"):
Interval:= loadproc(Interval, path, "Interval"):

end_proc():

# end of file #
