# $Date: 1994/10/03 22:54:05 $ $Author: kraume $ $Revision: 1.2 $ #
#--
intlib::subres(A,B) - computes the subresultant chain for the
polynomials A and B.
(R. Loos. Generalized Polynomial Remainder Sequences. In B. Buchberger, and
 G.E. Collins, and R. Loos, editors,
Computer Algebra Symbolic and Algebraic Computation)
--#
intlib::subres:=proc(A,B)
  local i,j,k,R,al,S;
begin
  i:=degree(A);
  j:=degree(B);
  if i>j then j:=i-1; end_if;
  S[j+1]:=A; S[j]:=B;
  R:=1;
  while not(iszero(S[j])) do
    i:=degree(S[j]);
    for k from j-1 downto i+1 do S[k]:=0; end_for;
    if j>i
      then S[i]:=intlib::sim(multcoeffs(S[j],(lcoeff(S[j])/R)^(j-i)));
    end_if;
    al:=lcoeff(S[j])^(degree(S[j+1])-i+1);
    S[i-1]:=intlib::sim
             (multcoeffs(divide(multcoeffs(S[j+1],al),S[j],Rem),(-R)^(i-j-2)));
    j:=i-1;
    R:=lcoeff(S[j+1]);
  end_while;
  return(S);
end_proc:
