# $Date: 1995/06/07 13:17:45 $ $Author: zimmerma $ $Revision: 1.4 $ #
#--
intlib::spde(A,B,C,n,m) - solves the polynomial differential equation AY'+BY=C 
where A,B,C and Y are in k[n] and call's one of the procedures pde_exp, pde_ln 
or pde_intvar
M. Bronstein, The Transcendental Risch Differential Equation, Journal of
Symbolic Computation, 1990, 9
--#
intlib::spde:=proc(A,B,C,n,m)
  local Y,P,x,i,test2;
# global k,k_sub; #
begin
# (i) #
#tt
  if test then print("*********(i)*********"); end_if;
tt#
  if iszero(C) then return(0); end_if;
  if m<0 then return(FAIL); end_if;
  G:=intlib::gcdk_n(A,B);
  C:=divide(C,G);
  if not(iszero(C[2])) then return(FAIL);
                       else C:=C[1];
  end_if;
  A:=divide(A,G,Quo); B:=divide(B,G,Quo);
# (ii) #
#tt
  if test then print("*********(ii)*********"); end_if;
tt#
  if iszero(B)
    then Y:=intlib::intt(expr(C),n);
         if Y=FAIL then return(FAIL); end_if;
         Y:=subs(Y,k[i]=k_sub[i] $ i=2..n);
         if (indets(Y,RatExpr) minus {op(k_sub)}) minus {op(Q_sub)} <> {}
           then return(FAIL);
           elif degree(poly(Y,[k_sub[n]]))>m
                then return(FAIL);
                else return(Y);
         end_if;
  end_if;
# (iii) #
#tt
  if test then print("*********(iii)*********"); end_if;
tt#
  if degree(A)>0
    then P:=intlib::pdioe(B,A,C); # R:=P[1]; Z:=P[2]; #
#tt
         if test then print("Z=",P[2],"R=",P[1]); end_if;
tt#
         if degree(P[1])>m then return(FAIL); end_if;
         Y:=intlib::spde(A,intlib::sim(intlib::diffs(A,n)+B),
                         intlib::sim(P[2]-intlib::diffs(P[1],n)),n,m-degree(A));
         if Y=FAIL then return(FAIL); end_if;
         return(Y*expr(A)+expr(P[1]));
  end_if;
# (iv) #
#tt
  if test then print("*********(iv)*********"); end_if;
tt#
  if degree(A)=0 and degree(B)>0
    then i:=degree(C)-degree(B);
         if i<0 or i>m then return(FAIL); end_if;
         x:=k_sub[n];
         P:=lcoeff(C)/lcoeff(B)*x^i;
         Y:=intlib::spde(A,B,
             intlib::sim(C-poly(P,[x])*B-poly(intlib::diffs(P,n),[x])*A),n,i-1);
         if Y=FAIL then return(FAIL); end_if;
         return(P+Y);
  end_if;
# (v) #
#tt
  if test then print("*********(v)*********"); end_if;
tt#
  if degree(A)=0 and degree(B)=0
    then case op(k[n],0)
           of hold(exp) do return(intlib::pde_exp(A,B,C,n,m));
           of hold(ln ) do return(intlib::pde_ln(A,B,C,n,m));
           of FAIL      do return(intlib::pde_var(A,B,C,m));
         end_case;
  end_if;
end_proc:
