# $Date: 1995/06/08 12:45:45 $ $Author: zimmerma $ $Revision: 1.8 $ #
#--
The input for the procedure intlib::rlti (Rioboo-Lazard-Trager Improvement) is 
the simple function f in the fieldextension k[n] splitted into numerator and 
denominator of the special part and the normal part of f respectively.
rlti(f_sNum,f_sDen,f_nNum,f_nNum,n) - computes g and h, which is n-reduced, so
that g'+h=f.
M. Bronstein, A Unification of Liouvillian Extension, AAECC 1990, 1
--#
intlib::rlti:=proc(f_sNum,f_sDen,A,B,n)
  local x,z,S,R,i,j,s,c,integral,zz,s1,s2,c0;
# global k,k_deg,Q_sub; #
begin
  if iszero(A) then return(f_sNum,f_sDen,0) end_if;
  x:=op(A,2);
  # check for int(1/(z^2+...),z) #
  if degree(B)=2 then
     z:=op(x);
     if expr(A)=1 and indets(expr(B)) intersect {op(k_sub)} = {z} then
        c:=coeff(B,1)/2;
        s:=coeff(B,0)-c^2; # B = (z+c)^2+s^2 #
        traperror((i:=bool(s<0)));
        if i<>TRUE then
           s:=sqrt(s);
           return(f_sNum,f_sDen,1/s*atan((z+c)/s))
        end_if
     end_if
  end_if;
  integral:=0;
  z:=genident();
  A:=A-poly(z,x)*intlib::diffs(B,n);
  S:=intlib::subres(A,B);
  userinfo(3,"subres prs:",S);
  S[0]:=intlib::primpart(poly(S[0],[z]))[1];
#tt
  if test then print("Resultante:",S[0]); end_if;
  if indets(expr(S[0])) intersect {op(k_sub)} <> {}
    then _proof(expr(A)/expr(B),
                "is not elementary integrable because",
                "the resultant contains non constant coefficients");
  end_if;
tt#
  if indets(expr(S[0])) intersect {op(k_sub)} <> {} then return(FAIL); end_if;
  R:=intlib::sqffTab(multcoeffs(S[0],1/lcoeff(S[0])));
  userinfo(3,"R=",R);
  for i from 1 to nops(R) do
    if R[i]=poly(1,[z]) then next; end_if;
    s:=intlib::gcdex(poly(lcoeff(S[i]),[z]),R[i])[2];
    s:=intlib::sim(poly(divide(s*poly(S[i],[z]),R[i],Rem),x));
    userinfo(3,"s=",s);
    if traperror((j:=factor(R[i])))=0
      then R[i]:=[];
           for c from 2 to nops(j) step 2 do
             j[c]:=poly(j[c],[z]);
             R[i]:=append(R[i],multcoeffs(j[c],1/lcoeff(j[c])));
           end_for;
      else R[i]:=[R[i]];
    end_if;
    userinfo(3,"factors of resultant: ",R[i]);
    for j from 1 to nops(R[i]) do
      case degree(R[i][j])
        of 1 do   c:=-coeff(R[i][j],0);
                  integral:=integral-c*degree(s)*op(k[n])*k_deg[n]
                            +c*ln(expr(subs(s,z=c)));
                  break;
        of 2 do   B:=-coeff(R[i][j],1)/2;
                  zz:=sqrt(B^2-coeff(R[i][j],0));
                  c:=B+zz,B-zz; # two roots #
                  s1:=subs(s,z=op(c,1));
                  c0:=coeff(s1,0)/lcoeff(s1);
                  s1:=expr(s1);
                  s2:=expr(subs(s,z=op(c,2)));
                  if degree(s)=1 
                  and Im(eval(subs(op(c,1),Q_sub[A]=Q[A]$hold(A)=1..nops(Q))))<>0 then 
                     # to avoid ln of complex numbers #
                     A:=B*ln(expand(s1*s2))+2*zz/I*atan((op(s,[2,1])+Re(c0))/Im(c0))
                  else A:=op(c,1)*ln(s1)+op(c,2)*ln(s2)
                  end_if;
                  integral:=integral+A
                            +coeff(R[i][j],1)*degree(s)*op(k[n])*k_deg[n];
                            # -(op(c,1)+op(c,2)) = coeff(R[i][j],1) #
                  break;
        otherwise zz:=genident(); # for RootOf #
		  integral:=_plus(integral,sum(z*(ln(expr(s))-k_deg[n]
				*degree(s)*op(k[n])),z=RootOf(subs(expr(R[i][j]),z=zz),zz)))
      end_case;
    end_for;
  end_for;
  return(f_sNum,f_sDen,integral);
end_proc:
