# $Date: 1994/10/03 22:53:50 $ $Author: kraume $ $Revision: 1.2 $ #
#--
intlib::pdioe(A,B,C) - solves the polynomial diophantine equation S*A+T*B=C for 
gcd(A,B)=1 and delivers S,T as a sequence, so that deg(S)<deg(B).
K.O. Geddes, Algorithms for Computer Algebra, Theorem 2.6.
It is often used to construct a partial fraction decomposition of 
C/(A*B)=S/B+T/A.
--#
intlib::pdioe:=proc(A,B,C)
  local D,S;
begin
  D:=intlib::gcdex(A,B);
  S:=divide(D[2]*C,B);
  return(intlib::sim(S[2],D[3]*C+S[1]*A));
end_proc:
