# $Date: 1995/06/08 12:52:48 $ $Author: zimmerma $ $Revision: 1.10 $ #
# intlib::lookup(e) returns FAIL or a primitive, the main variable is _X #

intlib::lookup := proc(f) local g,intg;
begin
   userinfo(2,"f=",f);
   if has(f,{sin,cos}) then
      g:=combine(f,sincos);
      intg:=intlib::sincos(g,_X);
      if not has(intg,FAIL) then return(intg)
      elif length(g)<length(f) then # avoid infinite loops between int and lookup #
         if type((intg:=intlib::int(g,_X)))<>FAIL then
            return(intlib::to_sincos(intg,_X))
         end_if
      end_if;
   end_if;
   FAIL
end_proc:

intlib::to_exp := proc(f)
begin
   eval(subs(f,hold(cos)=intlib::sub(hold(cos),Exp),hold(sin)=intlib::sub(hold(sin),Exp)))
end_proc:

# converts exp(n*I*x) to cos(n*x)+I*sin(n*x) #
intlib::to_sincos := proc(f,x) local n;
begin
   case type(f)
   of DOM_LIST do
   of "_equal" do
   of "ln" do
   of "_mult" do
   of "_plus" do return(map(f,intlib::to_sincos,x))
   of "exp" do
      n:=op(f)/I/x;
      if not has(n,x) and type(n)<>DOM_COMPLEX then return(cos(n*x)+I*sin(n*x))
      else return(f)
      end_if
   of "_power" do
      if type(op(f,1))="exp" and type(op(f,2))=DOM_INT then
         return(intlib::to_sincos(exp(op(f,[1,1])*op(f,2)),x))
      else return(intlib::to_sincos(op(f,1))^op(f,2))
      end_if
   otherwise f
   end_case
end_proc:

intlib::sincos := proc(f,x) # integrates a*sin(b*x) #
local b;
begin
   if not has(f,x) then return(f*x) end_if;
   case type(f)
   of "_plus" do return(map(f,intlib::sincos,x))
   of "sin" do b:=op(f)/x; if not has(b,x) then return(-cos(b*x)/b) else return(FAIL) end_if
   of "cos" do b:=op(f)/x; if not has(b,x) then return(sin(b*x)/b) else return(FAIL) end_if
   of "_mult" do
      b:=select(f,has,x);
      if type(b)<>"_mult" then # only one factor contains x #
         return(f/b*intlib::sincos(b,x))
      end_if
   end_case;
   FAIL
end_proc:

intlib::lookup(abs(_X)) := _X*abs(_X)/2:
intlib::lookup(1/sqrt(1-_X^2)) := asin(_X):
intlib::lookup(asin(_X)) := _X*asin(_X)+sqrt(1-_X^2):
intlib::lookup(sign(_X)) := _X*sign(_X):
