# $Date: 1995/06/07 13:17:49 $ $Author: zimmerma $ $Revision: 1.5 $ #
#--
intlib::intt(f,n) - is the internal integration
of the substituted function f in k(n)
--#
intlib::intt:=proc(f,n)
  local i,j,r,t,integral,q,x;
# global k,k_sub,k_deg,k_diff; #
begin
  userinfo(2,"f=",f,"n=",n);
  f:=intlib::split2(f,n); f[4]:=intlib::sqffTab(f[4]);
  userinfo(2,"split -> f=",f);
  f:=intlib::hermite(f,n);
  userinfo(2,"after hermite, f=",f);
  integral:=f[5]; f[5]:=NIL;
  f:=intlib::rlti(f,n);
  userinfo(2,"after rlti, f=",f);
#tt
  if f=FAIL then intlib::_proof("can't integrate normal part"); end_if;
tt#
  if f=FAIL then return(FAIL); end_if;
  integral:=integral+f[3]; f[3]:=NIL;
  if iszero(f[1]) then return(integral); end_if;
  case op(k[n],0)
    of hold(exp) do 
         userinfo(2,"dealing with exponential extension");
         userinfo(2,"num=",f[1],"den=",f[2]);
         r:=degree(f[1]); t:=degree(f[2]);
         for j from r downto -t do
           if j=0
              then 
                 i:=intlib::intt(coeff(f[1],t),n-1);
                 userinfo(2,"n=",n,"have to integrate:",coeff(f[1],t),"->",i);
                 if i=FAIL then return(FAIL) end_if;
              else 
                 i:=intlib::solveRde(j*k_diff[n],coeff(f[1],j+t),n-1);
                 userinfo(2,"solution of Risch DE is",i);
#tt
                   if i=FAIL
                     then intlib::_proof("can't solve Risch de",
                                               j*k_diff[n],coeff(f[1],j+t),n-1);
                   end_if;
tt#
                   if i=FAIL then return(FAIL); end_if;
           end_if;
           integral:=integral+i*k_sub[n]^j;
         end_for;
         break;
    of hold(ln) do 
         userinfo(2,"dealing with logarithmic extension");
         i:=lcoeff(f[1]); r:=degree(f[1]);
         x:=k_sub[n]; q:=table(i=0 $ hold(i)=0..r+1);
         for j from r downto 1 do
           q[j]:=intlib::intt(i,n-1);
           if q[j]=FAIL then return(FAIL); end_if;
           t:=n; n:=nops(k);
           q[j]:=intlib::tower(q[j]);
           n:=t;
#tt
           if indets(q[j])minus{k_sub[t]$hold(t)=1..n,op(Q_sub)}<>{}
             then intlib::_proof("the integral of ",i," = ",q[j],
                                 "is not in the correct form");
           end_if;
tt#
           if indets(q[j])minus{k_sub[t]$hold(t)=1..n,op(Q_sub)}<>{}
             then return(FAIL);
           end_if;
           q[j]:=poly(q[j],[x]);
           q[j+1]:=normal(q[j+1]+coeff(q[j],1)/(j+1));
           q[j]:=coeff(q[j],0);
           i:=coeff(f[1],j-1)-j*q[j]*k_diff[n];
         end_for;
         q[0]:=intlib::intt(i,n-1);
         if q[0]=FAIL then return(FAIL); end_if;
         integral:=_plus(integral,q[j]*x^j $ hold(j)=0..r+1);
         break;
    of FAIL do 
       userinfo(2,"dealing with",op(k[n],0));
       integral:=_plus(integral,
                         coeff(f[1],i-1)/i*k_sub[1]^i$i=1..degree(f[1])+1);
      break;
    otherwise return(FAIL);
  end_case;
  return(integral);
end_proc:
