# $Date: 1994/10/03 22:53:32 $ $Author: kraume $ $Revision: 1.2 $ #
#--
intlib::bound(A,B,C,n) - determins a bound for the degree of the solution Y of
the polynomial differential equation AY'+BY=C where A,B,C and Y are in k[n] and 
call's the procedure spde with this bound
M. Bronstein, The Transcendental Risch Differential Equation, Journal of
Symbolic Computation, 1990, 9
--#
intlib::bound:=proc(A,B,C,n)
  local a,b,c,i,d;
# global k_sub,k_deg,k_diff; #
begin
  d:=k_deg[n];
  a:=degree(A);
  if iszero(B) then b:=-1; else b:=degree(B); end_if;
  if iszero(C) then c:=-1; else c:=degree(C); end_if;
#tt
  if test
    then print(Unquoted,"n=",n,"determining bound","a=",a,"b=",b,"c=",c);
  end_if;
tt#
  case sign(a+d-1-b)
# a+d-1<b #
    of -1 do
      if d<1 and n>1 and a=b  # case (iv.2) #
        then i:=intlib::inttest(-lcoeff(B)/lcoeff(A),n);
#tt
             if test
               then print(Unquoted,"n=",n,
                          "have to integrate",lcoeff(B)/lcoeff(A),"->",i);
             end_if;
tt#
             if i<>FAIL
               then i:=i[2]*k_sub[n]^i[1];
                    d:=intlib::bound(intlib::sim(multcoeffs(A,i),multcoeffs(A,
                                  -lcoeff(B)/lcoeff(A)*i)+multcoeffs(B,i)),C,n);
                    if d=FAIL then return(FAIL); else return(i*d); end_if;
             end_if;
      end_if;
      return(intlib::spde(A,B,C,n,c-b));
# a+d-1=b #
    of  0 do
      case d
        of 0 do   i:=normal(-lcoeff(B)/(lcoeff(A)*k_diff[n]));  break;
        of 1 do   i:=intlib::inttest(-lcoeff(B)/lcoeff(A),n);
#tt
                  if test
                    then print(Unquoted,"n=",n,"have to bring ",
                             intlib::intt(-lcoeff(B)/lcoeff(A),n-1),
                             "into the form c*(",op(k[n],1),")-ln(y)","c,y=",i);
                  end_if;
tt#
                  if i<>FAIL then i:=i[1]; end_if;  break;
      end_case;
      if type(i)=DOM_INT then return(intlib::spde(A,B,C,n,max(i,c-b)));
                         else return(intlib::spde(A,B,C,n,c-b));
      end_if;
# a+d-1>b #
    of  1 do
      return(intlib::spde(A,B,C,n,max(0,c-a-d+1)));
  end_case;
end_proc:
