# $Date: 1995/03/21 15:36:47 $ $Author: kg $ $Revision: 1.4 $ #

# kg, 23/12/93 #

#--
groebner::test_polyset -- test if S is a list of polynomials of type t

groebner::test_polyset(S [, i, r])

S - list of polynomials
i - list of indets
r - coefficient ring, must be a field

If the type (i,r) is omitted, the polynomials in S must be of identical
type. The procedure returns an error if the list S is errorneous.
--#

groebner::test_polyset:= proc(S, i, r)
    local p;
begin
    if domtype(S) <> DOM_LIST then error("no polynomial set") end_if;
    if nops(S) = 0 then error("empty polynomial set") end_if;

    # get type if not given by i,r #
    if args(0) = 1 then
	p:= S[1];
	groebner::test_poly(p);
	i:= op(p,2);
	r:= op(p,3);
    end_if;

    # check domain #
    if domtype(op(S[1],3)) = DOM_DOMAIN then
	groebner::test_domain(op(S[1],3))
    end_if;

    # check S for consistency #
    for p in S do
	groebner::test_poly(p);
	if i <> op(p,2) or r <> op(p,3) then
	    error("polynomial types don't match")
	end_if
    end_for
end_proc:

# end of file #
