# $Date: 1995/03/13 13:53:20 $ $Author: kg $ $Revision: 1.5 $ #

# kg, 27/12/93 #

#--
groebner::reduce_basis -- auto-reduces a groebner basis from a list

groebner::reduce_basis(S)

S   - groebner basis given as list of monic sugared polynomials

returns a list of monic polynomials representing the reduced basis.

This version does only work with update.mu where redundant basis elements
are already deleted!
--#

groebner::term_less: # force loading #

groebner::reduce_basis:= proc(S)
    local R, i, h, o, p, lm;
begin
    case nops(S)
    of 0 do return([]);
    of 1 do return([S[1][1]]);
    end_case;
    # now S can't contain polynomials of degree 0 #

    S:= sort(S, groebner::term_less);
    
    R:= groebner::redset_insert([], S[1]);
    o:= groebner::order;
    for i from 2 to nops(S) do
        # S[i] can't be reduced by S[j] with j > i because of the sorting of S,
          so we need to reduce S[i] only by R.
          The leading term of S[i] can't be reduced by R because it is > than any
    	  leading term in R, so we split it away before reduction.
    	  Such the leading term of the new, reduced polynomial stays the same and
    	  can't in turn reduce any element in R; i.e. R need not to be reduced
    	  with the new polynomial. #
#
    	h:= groebner::reduce(S[i], R);
    	h[1]:= groebner::monic(h[1]);
    	R:= groebner::redset_insert(R, h);
#
    	p:= S[i][1];
    	lm:= lmonomial(p, o);
    	p:= p - lm;
    	h:= groebner::reduce([p, lterm(p, o), 0], R);
    	if h[1] = p then
    	    R:= groebner::redset_insert(R, S[i])
    	else
    	    R:= groebner::redset_insert(R, [groebner::monic(h[1] + lm), S[i][2], 0])
    	end_if
    end_for;

    # convert reducing set into polynomial list #
    map(_concat(op(R)), op, 1)
end_proc:

# end of file #
