# $Date: 1995/03/21 16:05:06 $ $Author: kg $ $Revision: 1.6 $ #

# kg, 29/12/93 #

#++
normalf -- returns normal form of p modulo polynomials in list S

normalf(p, S, [,o])

p   - polynomial
S   - list of polynomials (ideal)
o   - optional term ordering (LexOrder, DegInvLexOrder or DegreeOrder)

'DegInvLexOrder' is used if the order is not given.
++#

groebner::normalf:= proc(p, S, o)
    local zero, order, monic, R, h, conv;
begin
    if args(0) = 2 then o:= hold(DegInvLexOrder) end_if;
    if testargs() then
	if args(0) <> 3 and args(0) <> 2 then
	    error("wrong no of args")
	end_if;
        if domtype(S) <> DOM_LIST then
            error("no polynomial list")
        end_if;
        if nops(S) = 0 then
            error("no polynomials in list")
        end_if;
        if domtype(p) = DOM_POLY then
	    groebner::test_poly(p);
	    groebner::test_polyset(S, op(p,2..3));
	end_if;
	if not contains({hold(DegreeOrder), hold(LexOrder), hold(DegInvLexOrder)}, o) then
	    error("unknown order") 
	end_if
    end_if;

    if domtype(p) <> DOM_POLY then
	S:= gcdlib::expr2polys(append(S, p), Type::Rational);
	if S = FAIL then error("not a rational polynomial") end_if;
	p:= S[nops(S)];
	S[nops(S)]:= NIL;
	conv:= expr
    else
	conv:= id
    end_if;

    if iszero(p) then return(p) end_if;
    S:= select(S, not iszero);
    if nops(S) = 0 then return(p) end_if;
    if min(op(map(S, degree))) = 0 then return(p-p) end_if;

    # set actual order and zero #
    order:= groebner::order;
    groebner::order:= o;
    zero:= groebner::zero;
    groebner::zero:= p^0;
    groebner::zero:= groebner::zero - groebner::zero;
    
    # install normalizing routine #
    monic:= groebner::monic;
    if op(p,3) = hold(Expr) then
	groebner::monic:= groebner::primpart
    else
	groebner::monic:= groebner::normalize
    end_if;

    # normalize polynomials #
    S:= map(S, groebner::monic);

    # create reducing set and reduce #
    R:= [];
    for h in S do
        R:= groebner::redset_insert(R, [h, lterm(h, o), 0])
    end_for;
    p:= groebner::reduce([groebner::monic(p), lterm(p, o), 0], R)[1];
    if not iszero(p) then 
        p:= groebner::monic(p);
        if op(p,3) = hold(Expr) then
            if sign(lcoeff(p,o)) < 0 then
                p:= multcoeffs(p, -1)
            end_if
        end_if
    end_if;

    # re-install original globals #
    groebner::order:= order;
    groebner::zero:= zero;
    groebner::monic:= monic;

    conv(p)
end_proc:

# end of file #
