# $Date: 1994/05/31 13:20:01 $ $Author: linus $ $Revision: 1.1 $ #

# kg, 09/12/93 #

#--
gcdlib::univ_mod_gcd -- compute the gcd of univariant IntMod-polynomials

gcdlib::univ_mod_gcd(p1, p2)

p1,p2 - univariant non-zero polynomials over IntMod

gcdlib::univ_mod_gcd computes the gcd of 2 non-zero univariant polynomials
over IntMod(p) via the euclidean algorithm. p must be prime. The arguments
are not checked further. The result is not normalized.
--#

gcdlib::univ_mod_gcd:= proc(a, b)
    local t;
begin
    if iszero(a) then return(b) end_if;
    if iszero(b) then return(a) end_if;

    # normalize args #
    a:= multcoeffs(a, 1/lcoeff(a));
    b:= multcoeffs(b, 1/lcoeff(b));

    # Euclidean Alg #
    while not iszero(b) do
	t:= divide(a, b, Rem);
	a:= b;
	b:= t;
    end_while;
    a
end_proc:

# end of file #
