# $Date: 1995/06/23 11:36:42 $ $Author: kg $ $Revision: 1.7.2.2 $ #

# kg, 14/09/94 #

#--
Scale -- scale exponents with factors

Scale(p, S)

p - non-zero polynomial
S - list containing scale factor for each variable of p

Multiplies each exponent of variable xi of p with factor S[i]. The resulting
new exponents must be non-negative integers.
--#

alias(
Scale(p, S) =
    _plus(multcoeffs(poly(_mult(op(zip(X, zip(degreevec(nthterm(p,i)), S, _mult), _power))), 
    			  X, T),
		     nthcoeff(p,i))
    	  $ hold(i)=1..nterms(p))
):

#--
gcdlib::special_cases(a, b, gcdp, normp)

a, b        - polynomials
gcdp, normp - procedures

Computes the gcd of a and b. At first some special cases are handled.
Only if neccecary the 'real' gcd routine 'gcdp' is called. 'normp' is
used to normalize the result if a divides b or vice versa.
--#

gcdlib::special_cases:= proc(a, b, gcdp, normp)
    local n, da, db, ma, mb, i, j, x, g, T, X, Xn, S, f, doScale;
begin
    X:= op(a,2);
    n:= nops(X);
    T:= op(a,3);

    # ldegree(x) > 0 ? #
    f:= a^0;
    for i from 1 to n do
	x:= X[i];
	ma:= ldegree(a, x);
	mb:= ldegree(b, x);
	if ma + mb <> 0 then
	    if ma <> 0 then
		a:= divide(a, poly(x^ma, X, T), Exact)
	    end_if;
	    if mb <> 0 then
		b:= divide(b, poly(x^mb, X, T), Exact)
	    end_if;
	    f:= f * poly(x, X, T)^min(ma,mb);
	end_if
    end_for;

    if divide(a, b, Exact) <> FAIL then
        return(f * normp(b, a))
    elif degree(b) < 2 then
        return(f * normp(poly(content(b), X, T), a))
    elif divide(b, a, Exact) <> FAIL then
        return(f * normp(a, b))
    elif degree(a) < 2 then
        return(f * normp(poly(content(a), X, T), b))
    end_if;

    # substitution x -> x^(1/g) possible? #
    if n = 1 then
	da:= [[ degree(nthterm(a,j)) $ j=1..nterms(a) ]];
	db:= [[ degree(nthterm(b,j)) $ j=1..nterms(b) ]];
    else
	da:= [ degreevec(nthterm(a,j)) $ j=1..nterms(a) ];
	db:= [ degreevec(nthterm(b,j)) $ j=1..nterms(b) ];
	da:= [ map(da, _index, j) $ j=1..n ];
	db:= [ map(db, _index, j) $ j=1..n ];
    end_if;

    S:= zip(da, db, fun(max(1, igcd(0, op(args(1)), op(args(2))))));
    doScale:= bool(select(S, _equal, 1) <> S);
    if doScale then
        g:= map(S, 1/id);
        a:= Scale(a, g);
        b:= Scale(b, g);
    end_if;

    # reduce to common indets with positive degree #
    Xn:= X;
    i:= 1;
    while i <= nops(Xn) do
	x:= Xn[i];
	if degree(a, x) = 0 then
	    Xn[i]:= NIL;
	    if nops(Xn) = 0 then break end_if;
	    a:= coeff(a, x, 0);
	    if degree(b, x) = 0 then
		b:= coeff(b, x, 0)
	    else
		b:= gcd(coeff(poly(b, [x], Poly(Xn,T))))
	    end_if;
	    i:= 0;
	elif degree(b, x) = 0 then
	    Xn[i]:= NIL;
	    if nops(Xn) = 0 then break end_if;
	    b:= coeff(b, x, 0);
	    a:= gcd(coeff(poly(a, [x], Poly(Xn,T))));
	    i:= 0;
	end_if;
	i:= i+1
    end_while;

    if nops(Xn) = 0 then
	g:= f^0
    else
	g:= gcdp(a, b);
	if Xn <> X then g:= poly(g, X, T) end_if
    end_if;

    if doScale then
        f * Scale(g, S);
    else
	f * g
    end_if;
end_proc:

unalias(Scale):

# end of file #
