# $Date: 1994/05/31 13:20:00 $ $Author: linus $ $Revision: 1.1 $ #

# kg, 09/12/93 #

#--
gcdlib::poly_mod_content -- compute content of polynomial with modular
	polynomial coeffs

gcdlib::poly_mod_content(a)

a   - polynomial over Poly([x1,...], IntMod(p))
--#

gcdlib::poly_mod_content:= proc(a)
    local i, ac, cont, one;
begin
    ac:= [ coeff(a) ];
    if nops(ac) = 1 then
        cont:= ac[1];
	return(multcoeffs(cont, 1/lcoeff(cont)))
    end_if;
    one:= poly(1, op(ac[1], 2..3));

    # check for trivial case #
    if min(op(map(ac, degree))) = 0 then return(one) end_if;

    # sort coeffs according to increasing degrees #
    if nops(ac) > 2 then
	ac:= sort(ac, proc(p, q) begin bool(degree(p) < degree(q)) end_proc);
    end_if;

    # compute gcd #
    cont:= ac[1];
    for i from 2 to nops(ac) do
	cont:= gcdlib::mod_gcd(cont, ac[i]);
	if degree(cont) = 0 then return(one) end_if
    end_for;
    cont
end_proc:

# end of file #
