# $Date: 1994/05/31 13:19:55 $ $Author: linus $ $Revision: 1.1 $ #

# kg, 09/12/93 #

#++
gcdlib::int_mod_gcd -- compute gcd of integer polynomials using modular
	algorithm

gcdlib::int_mod_gcd(a, b)

a,b - non-zero polynomials of type 'Expr' over the integers

gcdlib::int_mod_gcd computes the gcd of 2 non-zero polynomials over the
integers via a modular gcd algorithm. The arguments are not checked.

See K.O.Geddes et al "Alg. for Computer Algebra", Kluwer 1992, pp307
++#

gcdlib::int_mod_gcd:= proc(a, b)
    local x, ca, cb, c, g, n, m, lim, p, q, ap, bp, cp, ce, h;
begin
    # get last indet #
    x:= op(a,[2, nops(op(a,2))]);

    # remove integer content #
    ca:= icontent(a);
    a:= multcoeffs(a, 1/ca);
    cb:= icontent(b);
    b:= multcoeffs(b, 1/cb);

    # get coefficient bound for gcd #
    c:= igcd(ca, cb);
    g:= igcd(lcoeff(a), lcoeff(b));
    n:= min(degree(a,x), degree(b,x));
    lim:= (2^(n+1))* abs(g) * min(norm(a), norm(b));

    # CRA interpolation loop #

    q:= nextprime(g+1);
    p:= max(1000003, q);
    if p < lim then
	p:= max(4294967029, q);
	if p < lim then
	    p:= max(4611686018427380059, q);
	    if p < lim then
		p:= min(21267647932558653966460912964485510037, nextprime(lim));
	    end_if;
	end_if;
    end_if;

    q:= 1;
    h:= poly(0, op(a,2..3));

    while TRUE do
	# get modular gcd #
	ap:= poly(a, IntMod(p));
	bp:= poly(b, IntMod(p));
	cp:= gcdlib::mod_gcd(ap, bp);
	m:= degree(cp,x);

	# normalize such that g mod p = lcoeff(cp) #
	cp:= multcoeffs(cp, (g mod p)/lcoeff(cp));

	# test for unlucky homomorphism #
	if m < n then
	    q:= p;
	    h:= poly(cp, Expr);
	    n:= m;
	elif m = n then

	    # update coeffs using integer chinese reminder #
	    if q = 1 then
		h:= poly(cp, Expr);
	    else
		ce:= poly(cp, Expr);
		# combine h and cp:
		  compute integer chinese reminder of hi mod q and ci mod p
		  for the coeffs hi of h and ci of cp. The individual coeff
		  of the result is given by:
			p * mods((hi-ci)/p, q) + ci
		#
		h:= multcoeffs(mapcoeffs(multcoeffs(h - ce, 1/p), mods, q), p)
			+ ce;
	    end_if;
	    q:= p * q;
	end_if;

	# test for completition #
	if q > lim then

	    # remove integer content, test by division #
	    ce:= multcoeffs(h, 1/icontent(h));

	    if divide(a, ce, Exact) <> FAIL then
	    	if divide(b, ce, Exact) <> FAIL then
		    return(multcoeffs(ce, c))
		end_if
	    end_if

	elif m = 0 then
	    return(poly(c, op(a,[2..3])))
	end_if;

	# get next modulus #
	repeat
	    p:= nextprime(p+2);
	until domtype(g/p) <> DOM_INT end_repeat;
    end_while
end_proc:

# end of file #
