# $Date: 1994/05/31 13:19:52 $ $Author: linus $ $Revision: 1.1 $ #

# kg, 09/12/93 #

#--
gcdlib::heu_gcd -- compute heuristic gcd of 2 polynomials over the integers

gcdlib::heu_gcd(p1, p2)

p1,p2 - primitive non-zero polynomials over the integers

gcdlib::heu_gcd computes the gcd of two non-zero primitive polynomials with
integer coeffizients by a heuristic method. The procedure returns the gcd or
FAIL resp. FALSE if the heuristic fails. The output must be made primitive!

The routine should be used only if the number of indeterminates is less
than 5.

See K.O.Geddes et al "Alg. for Computer Algebra", Kluwer 1992, pp320
--#

gcdlib::heu_gcd:= proc(a, b)
    local x, xv, g, tries, bound;
begin
    x:= op(a,[2,1]);
    bound:= max(degree(a,x), degree(b,x));
    xv:= 2*min(norm(a), norm(b)) + 2;

    for tries from 1 to 6 do
	if strlen("".xv) * bound > gcdlib::max_numlen then
	    return(FALSE)
	end_if;
	if nops(op(a,2)) = 1 then
	    g:= igcd(evalp(a,x=xv), evalp(b,x=xv))
	else
	    g:= gcdlib::heu_gcd(evalp(a,x=xv), evalp(b,x=xv));
	    if g = FALSE then return(FALSE) end_if
	end_if;
	if g <> FAIL then
	    g:= genpoly(g, xv, x);
	    if divide(a, g, hold(Exact)) <> FAIL then
		if divide(b, g, hold(Exact)) <> FAIL then
		    return(g)
		end_if
	    end_if
	end_if;
	xv:= trunc(xv * 73794 / 27011);
    end_for;
    FAIL
end_proc:

# end of file #
