# $Date: 1995/05/26 08:00:26 $ $Author: kg $ $Revision: 1.2 $ #

# kg, 16/12/94 #

#++
faclib::sqrfree_poly -- square-free factorization of polynomial

faclib::sqrfree_poly(p)

p - polynomial over UFD of characteristic 0 or finite field

faclib::sqrfree_poly(p) returns a list of the form [c,f1,e1,...,fn,en]
where c is the contents of p and the fi are the square-free factors
of order ei of p. Each fi is of the same type as p.

The type of the polynomial p is not checked (see sqrfree).
++#

faclib::sqrfree_poly:= proc(p)
    local l, f, c, i, j, X, T, ff, n;
begin
    X:= op(p,2);
    T:= op(p,3);
    
    # is T an UFD of char. 0 or a finite field? #
    if domtype(T) = DOM_DOMAIN then
        if T::characteristic = FAIL then
            ff:= FALSE	# assume that T is UFD of char.0 #
        elif T::characteristic = 0 then
            ff:= FALSE
        else
            ff:= TRUE;
            n:= T::constructor_args[1]; #||| should be representaion-independant #
        end_if
    elif T = hold(Expr) then
        ff:= FALSE
    else
        ff:= TRUE;
        n:= op(p,[3,1]);
    end_if;
    
    # remove contents #
    c:= content(p);
    if domtype(T) = DOM_DOMAIN then
    	p:= mapcoeffs(p, T::divex, c)
    else
    	p:= multcoeffs(p, 1/c)
    end_if;
    
    f:= faclib::pre_factor(p);
    l:= [c];
    
    for i from 1 to nops(f) step 2 do
    	if nterms(f[i]) = 1 or degree(f[i]) <= 1 then
    	    l:= append(l, poly(f[i],X,T), f[i+1])
    	else
    	    if ff then
    	        c:= faclib::sqrfree_ffield(f[i], n, 1);
    	    else
    	        c:= faclib::sqrfree_yun(f[i]);
    	    end_if;
    	    l:= append(l, (poly(c[2*j-1],X,T), c[2*j]*f[i+1]) $ j=1..(nops(c) div 2))
    	end_if
    end_for;
    
    l
end_proc:

# end of file #
