# $Date: 1994/09/27 09:59:39 $ $ Author: yuan $ #

#--
faclib::set_x -- choose a main variable for the input multivariate polynomial.  
                 Output is a list of variables with the variable choosen at
                 the first place.  

faclib::set_x(p)
p - a primitive square free multivariate polynomial in Z[x1..xn] and its
    variables are already arranged in ascending degrees
--#

faclib::set_x:=proc(p)
local d, dv, i, j, ld, lp, lt, lv, nv, td, t, v, xn, xx;
begin
    xx:=[];
    d:=degree(p,op(p,[2,1]));
    # choose the variable x0 that p(x0) has the lowest degree #
    for i in op(p,2) do 
        if degree(p,i)=d then 
           xx:= append(xx,i);
        else break; 
        end_if;
    end_for;
    if nops(xx)=1 then 
       return(op(op(p,2))); 
    end_if;
    lp:=map(xx, proc(xn) begin poly(lcoeff(poly(p,[xn])),op(p,2)) end_proc); 
    d:=map(lp,degree);
    # then choose the variable x0 that lcoeff(p(x0)) has the lowest degree #
    if (ld:=min(op(d)))<2 then 
       for i from 1 to nops(xx) do
           if d[i]=ld then 
              return(xx[i],op(p,[2,j])$hold(j)=1..(i-1),\
                           op(p,[2,j])$hold(j)=(i+1)..nops(op(p,2)));
           end_if;
       end_for;
    else t:=map(lp,nterms);
         # then choose the variable that lcoeff(p(x0)) has the fewest terms #
         if (lt:=min(op(%)))<3 then 
            for i from 1 to nops(xx) do 
                if t[i]=lt then 
                   return(xx[i],op(p,[2,j])$hold(j)=1..(i-1),\
                                op(p,[2,j])$hold(j)=(i+1)..nops(op(p,2)));
                end_if;
            end_for;
         else 
              # otherwise, choose the variable x0 that p(x0) has the smallest #
              # value of (number of variables of lcoeff(p(x0)))*              #
              # (degree of lcoeff(p(x0)))                                     #
              dv:=map(lp,degreevec);
              nv:=map(dv,nops);
              td:=map(dv,proc(xn) begin _plus(op(xn)); end_proc);
              v:=[nv[i]*td[i]$hold(i)=1..nops(xx)];
              lv:=min(op(v));
              for i from 1 to nops(xx) do 
                  if v[i]=lv then 
                     return(xx[i],op(p,[2,j])$hold(j)=1..(i-1),\
                                  op(p,[2,j])$hold(j)=(i+1)..nops(op(p,2)));
                  end_if;
              end_for;
         end_if;
    end_if;
end_proc:
