# $Date: 1994/12/20 08:08:02 $ $Author: kg $ $Revision: 1.2 $ #

# kg, 16/12/94 #

#++
faclib::pre_factor -- split trivial factors apart

faclib::pre_factor(p)

p - primitive polynomial

faclib::pre_factor(p) returns a list [f1,e1,...,fn,en] such that
p = f1^e1*...*fn^en. The factors fi may have less indets that p.

faclib::pre_factor removes unused unknowns and splits apart factors
of the form x^k and the contents of p with respect to each unknown 
xi in turn.
++#

faclib::pre_factor:= proc(p)
    local i, d, f, q, x, X, Y, T;
begin
    if degree(p) = 0 then return([]) end_if;
    f:= [];
    X:= op(p,2);
    T:= op(p,3);
    
    # remove factors of the form x^d #
    if ldegree(p) <> 0 then
    	for x in X do
    	    d:= ldegree(p,x);
    	    if d <> 0 then
    	    	q:= poly(x, [x], T);
    	    	p:= divide(p, poly(q,X,T)^d, Exact);
    	    	f:= append(f, q, d);
    	    end_if;
    	end_for;
    end_if;
    
    if degree(p) = 0 then return(f) end_if;
    if nops(X) = 1 then return(append(f, p, 1)) end_if;

    # remove unused indets #
    X:= select(X, fun(bool(degree(p, args(1)) <> 0)));
    p:= poly(p, X);
    if nops(X) = 1 then return(append(f, p, 1)) end_if;

    # view p as polynomial in X[i] and remove content #
    for i from 1 to nops(X) do
    	Y:= X;
    	Y[i]:= NIL;
	q:= content(poly(p, [X[i]], Poly(Y,T)));
	if degree(q) <> 0 then
	    p:= divide(p, poly(q,X,T), Exact);
	    f:= f . faclib::pre_factor(q);
	end_if
    end_for;
    
    # remove unused indets #
    if degree(p) = 0 then return(f) end_if;
    X:= select(X, fun(bool(degree(p, args(1)) <> 0)));
    append(f, poly(p, X), 1)
end_proc:

# end of file #
