# $Date: 1994/09/27 09:59:07 $ $ Author: yuan $ #

#--
faclib::pfactor -- return the factorization of polynomial in Z, output is given
                   in form [f1,e1,..,fn,en] and fi is in polynomial form, 
                   p=f1^e1*..*fn^en.

faclib::pfactor(p,c)
p - a primitive polynomial in Z has no monomial factor 
c - an integer number, may equal to 0, 1, or 2

faclib::pfactor get the factors with different variables and the factors with
different powers, then factorize these factors
--#

faclib::pfactor:=proc(p,c)
local d, d0, f, ff, fq, fs, i, j, pf, qfree, x, x0;
begin

    # for polynomial of degree 1 return input,   #
    # for binomial use faclib::binomial directly #
    if degree(p)=1 then 
       return([p,1]);
    elif nterms(p)=2 then 
         fs:=faclib::binomial(nthmonomial(p,i)$hold(i)=1..2);
         return([(op(fs,i),1)$hold(i)=1..nops(fs)]);
    end_if;
    # sort variables of multivariate polynomial according to ascending degrees #
    if nops(op(p,2))>1 then 
       p:=faclib::indsort(p); 
    elif c=0 then 
         c:=1; 
    end_if;
    # c=0: polynomial may be factorized into factors with different variables #
    if c=0 then 
       f:=[];
       if degree(p,op(p,[2,1]))=1 then 
          if (pf:=faclib::pfs(p,op(p,[2,1])))<>1 then
             f:=f.faclib::pfactor(poly(expr(pf)),0); 
             p:=poly(expr(divide(p,pf,Exact)));
          end_if;
          return(append(f,p,1)); 
       end_if;
       for x in op(p,2) do 
           if degree(poly(p,[x]))>0 then 
              if (pf:=faclib::pfs(p,x))<>1 then
                 f:=f.faclib::pfactor(poly(expr(pf)),0);
                 p:=poly(expr(divide(p,pf,Exact)));
              end_if;
           end_if;
       end_for;
       return(f.faclib::pfactor(p,1));
    else 
         # for c>0 and sorted polynomial, if degree of its # 
         # first variable is 1, then it is irreducible     #
         x0:=op(p,[2,1]); 
         if (d0:=degree(p,x0))=1 then 
            return([p,1]);
         elif c=2 then 
              # c=2: polynomial is square free and cannot be factorized into  #
              # factors with different variables, for bivariate polynomial of #
              # degree 2, use faclib::pdeg2, for univariate polynomial, use   #
              # faclib::ufactor, for multivariate use faclib::homo at first   #
              if d0=2 and nops(op(p,2))<3 then
                 fs:=faclib::pdeg2(p,x0);
              elif nops(op(p,2))=1 then 
                   fs:=faclib::ufactor(multcoeffs(p,sign(lcoeff(p))),x0);
              else fs:=faclib::homo(d0,x0,p);
              end_if;
              return([(op(fs,i),1)$hold(i)=1..nops(fs)]);
         end_if;
    end_if;
    # c=1: polynomial may be factorized into factors with different powers #
    qfree:=faclib::quafree(p);
    ff:=[];
    for i from 1 to nops(qfree)/2 do
        fq:=faclib::pfactor(op(qfree,2*i-1),2);
        d:=op(qfree,2*i);
        ff:=ff.subsop(fq,((2*j)=op(fq,2*j)*d)$hold(j)=1..nops(fq)/2);
    end_for;
    return(ff);       
end_proc:            


  
