# $Date: 1994/11/08 17:30:23 $ $ Author: yuan $ #

#--
faclib::mfactor -- return the factorization of multivariate polynomial in
                   Z[x1..xn], output is a list of factors in polynomial form.

faclib::mfactor(p)
p - a primitive square free multivariate polynomial in Z[x1..xn]

faclib::mfactor choose a main variable x1, factorize the lcoeff of p in Z[x1] at
first, then random choose a suitable set of value x2..xn, factorize univariate p in Z[x1,x2..xn], at last lift the factors from univariate to multivariate 
--# 

faclib::mfactor:=proc(p)
local bn, d, f, fb, fm, fs, i, lcont, lfs, lgs, ll, minfs, n0, nf, nl, p0, pl,\
      x0, xl, xx;
begin
    # choose the main variable #
    xl:=[faclib::set_x(p)];
    p:=poly(p,xl); 
    x0:=xl[1]; 
    bn:=map([xl[i]$hold(i)=2..nops(xl)], proc(xx) begin xx=0 end_proc); 
    p0:=poly(p,[x0]);
    minfs:=degree(p0)+1; 
    # factorize the leading coefficient of p in Z[x1] #
    fs:=factor(lcoeff(p0)); 
    lcont:=op(fs,1);
    nl:=(nops(fs)-1)/2;
    lfs:=[op(fs,2*i)$hold(i)=1..nl]; 
    lgs:=[op(fs,2*i+1)$hold(i)=1..nl];
    faclib::Rn:=-1; 
    faclib::Rgb:=3; 
    repeat minfs:=minfs-1;
           if minfs=1 then 
              return([p]);
           end_if;
           nf:=0;
           # random choose a suitable set of evaluation point of x2..xn #
           repeat fb:=faclib::set_b(p,bn,lfs,lcont,tcoeff(poly(p,[x0])));
                  # factorize the polynomial in univariate case #
                  f:=faclib::pfactor(multcoeffs(fb[1],sign(lcoeff(fb[1]))),2);
                  f:=[op(f,2*i-1)$hold(i)=1..nops(f)/2];
                  if (n0:=nops(f))=1 then 
                     return([p]);
                  elif n0<minfs then 
                       minfs:=n0; 
                       nf:=1;
                  elif n0=minfs then 
                       nf:=nf+1; 
                  end_if;
           # when the number of factors of univariate factorization are #
           # the same for two sets of random x2..xn, can try to lift    # 
           # them to multivariate case                                  #   
           until nf=2 end_repeat;
           # restore the lead coefficient of p in Z[x1] #
           if (fm:=faclib::mrestore(p,[multcoeffs(f[1],sign(lcoeff(fb[1]))),\
              op(f,i)$hold(i)=2..nops(f)],minfs,lfs,lgs,fb[i]$hold(i)=2..4))\
              <>FAIL then 
              # pl is the prime number in which the lifting done, it must be #
              # larger than the bound (see page 229-230, Proceedings of the  #
              # 1986 symposium on symbolic and algebraic computations, July  #
              # 21-23, 1986, Waterloo, Ontarro), and not divide lcoeff of p  #
              # in Z[x1,a2..an], and in Zpl p(x1,a2..an) must be square free # 
              d:=degreevec(fm[1]);
              d:=map(d,proc(xx) begin fact(2*xx)/_power(fact(xx),2) end_proc);
              pl:=1+trunc(norm(fm[1],2)*float(sqrt(_mult(d[i]$\
                                                         hold(i)=1..nops(d)))));
              ll:=lcont*fb[2]*lcoeff(fb[1]);
              repeat pl:=faclib::getprime(ll,pl); 
                     f:=poly(fb[1],IntMod(pl));
              until type(expr(gcd(f,Dpoly([1], f))))=DOM_INT end_repeat;
                                  # diff(f,x0) #
              if (f:=faclib::mhensel(minfs,fm,fb[3],pl,x0))<>FAIL then 
                 return(f);
              else print(Unquoted, "please sent the following message to \ 
                         the author of FACLIB(yuan@uni-paderborn.de)",\
                         p,fb,fm,pl); 
              end_if;
           else print(Unquoted, "please sent the following message to \
                      the author of FACLIB(yuan@uni-paderborn.de)",\
                      p,f,minfs,lfs,lgs,fb);
           end_if;
    # seldom, unlucky case is that the number of factors in  #
    # univariate case is more than that of multivariate case #
    until minfs=1 end_repeat;
end_proc:


