
#++
faclib::factor_expr -- factor expression with given factorizer

faclib::factor_expr(p, fac)

p   - polynomial expression over the rationals
fac - factorizer

Returns a list of the form [c, f1, e1,...,fn, en] such that p=c*f1^e1*...
*fn^en and c is the content of p.

fac must be a procedure which takes an rational polynomial q and returns
a list of the form [c, f1, e1,...,fn, en] such that the fi are polynomials
and q = c*f1^e1*...*fn^en.
++#

faclib::factor_expr:= proc(p, fac)
    local l, i, j, f, e, c;
begin
    # special cases which may save some time... #
    case type(p)
    of DOM_INT do
    of DOM_RAT do
    	return([p]);
    	
    of "_power" do
        j:= op(p,2);
        if domtype(j) <> DOM_INT then error("not a polynomial") end_if;
        if j < 1 then error("not a polynomial") end_if;
        l:= faclib::factor_expr(op(p,1), fac);
        return([ l[1]^j, (l[2*i], l[2*i+1]*j) $ i=1..(nops(l) div 2) ]);

    of "_mult" do
	c:= 1;
	f:= table();
	for e in p do
	    e:= faclib::factor_expr(e, fac);
	    c:= c*e[1];
	    # collect factors in f #
	    for j from 2 to nops(e) step 2 do
	    	if contains(f, e[j]) then
	    	    f[e[j]]:= f[e[j]] + e[j+1]
	    	else
	    	    f[e[j]]:= e[j+1]
	    	end_if
	    end_for;
	end_for;
	return([ c, op(op(f,i)) $ i=1..nops(f) ]);
    end_case;
    
    p:= poly(p);
    if p = FAIL then error("not a polynomial") end_if;
    if not testtype(p, Type::PolyOf(Type::Rational)) then
        error("not a rational polynomial")
    end_if;
    
    # eventually factor using fac #
    l:= fac(p);
    [ l[1], (expr(l[2*i]), l[2*i+1]) $ i=1..(nops(l) div 2) ];
end_proc:

# end of file #
