# #
# $Date: 1995/06/20 11:12:51 $ $Author: frankp $ $Revision: 1.34.2.1 $ #

# #
# frankp, 03/11/94 #

#++
  SqMatrix.mu

	SquareMatrix -- the domains of square matrices

	SquareMatrix(n,[R])

	n - dimension (positive integer)
	R - (optional) the coefficient domain (a Rng)

	A domain SquareMatrix(n,R) created by SquareMatrix represents
	the Rng of n times n matrices with coefficients from a Rng R.

	If 'R' is missing then the coefficient domain will be the
	domain 'ExpressionField()'.

	An element of SquareMatrix(n,R) has the same representation as
	an element of the domain Matrix(R). This ensures that all methods
	for Matrix(R) may be used by SquareMatrix(n,R).

	Note that the results of the methods "delRow", "delCol", 
	"stackMatrix", "concatMatrix", "row" and "col" will be
	elements of the super domain Matrix(R).
 
	The method "newThis" (inherited from Matrix(R)) must be used
	with coution because this method does not tests its arguments
	(thus it is possible to create matrices which are non-square,
	for example).

	Entries: one, zero

	Methods: random
++#

SquareMatrix:= DomainConstructor(
# name #
    SquareMatrix,
# arguments #
    [ n, R ],
# local variables #
    [ Rzero, Rone ],
# initialisation #
    (if args(0) < 1 or args(0) > 2 then error("wrong no of args") end_if;
     if not testtype( n,Type::PosInt ) then
	error("dimension must be a positive integer")
     end_if;
     if args(0) = 1 then R := ExpressionField()
     elif not (R::hasProp( Rng ) = TRUE) then
	error("coefficients must be from a Rng")
     end_if;
     Rone := R::one;
     Rzero := R::zero
    ),
# super-domains #
    Matrix(R),
# categories #
    [ SquareMatrixCat(R) ],
# axioms #
    [ (if R::hasProp( canonicalRep ) then canonicalRep end_if) ],
# #
# new()#
    "new" = proc(x)
        local i, j, t, a, f, l;
    begin
        if testargs() then
	    l := [args()];
	    if args(0) > 2 then
		if testtype( l[1],Type::PosInt ) and 
		   testtype( l[2],Type::PosInt ) 
		then
		    l[1] := NIL; l[1] := NIL
		end_if
	    end_if;
            case nops(l)
	    of 0 do break
	    of 2 do if l[2] <> hold(Diagonal) then
			error("expecting 'Diagonal' as option")
		    end_if 
            of 1 do if x::hasProp( MatrixCat ) = TRUE 
		    or domtype(x) = DOM_ARRAY then
			if domtype(x) = DOM_ARRAY then
			    if op(x,[0,1]) <> 2 then
                    		error("array has invalid dimension")
			    end_if;
			    if [op(x,[0,2,2])-op(x,[0,2,1]),
			    op(x,[0,3,2])-op(x,[0,3,1])] <> [n-1,n-1]
			    then
				error("array has invalid dimension")
			    end_if
			elif x::dimen(x) <> [n,n] then
			    error("matrix has invalid dimension")
                	end_if;
			if nops(l) = 2 then error("wrong no of args") end_if
		    end_if;
		    break
            otherwise
                error("wrong no of args")
            end_case
        end_if;

	l := [args()];
	if args(0) > 2 then
	    if testtype( l[1],Type::PosInt ) 
	    and testtype( l[2],Type::PosInt ) 
	    then
		l[1] := NIL; l[1] := NIL
	    end_if
	end_if;

        case nops(l)
        of 0 do return( new(this,n,n,array(1..n,1..n,[[Rzero $ n] $ n])) )
	of 2 do
        of 1 do if domtype( x ) = DOM_ARRAY 
		or x::hasProp( MatrixCat ) = TRUE then
		    t := this::convert( x );
                    if t <> FAIL then return( t ) end_if;
                    t := x::convert_to( x,this );
                    if t <> FAIL then return( t ) end_if;
                    error("unable to convert the argument")
		end_if;
		t := l[1]; l := nops(l);
                f := fun(
                        (if domtype(args(1)) = R then
                             args(1)
                         else
                             R::convert( args(1) );
                             if % <> FAIL then
                                 %
                             else
                                 (args(1))::convert_to( args(1),R )
                             end_if
                         end_if)
                      );
                if domtype(t) = DOM_PROC or domtype(t) = DOM_EXEC then
                    if l = 2 then
                        a := array(1..n,1..n,[ [Rzero $ n] $ n]);
                        for i from 1 to n do
                            a[i,i] := f(t(i,i));
                            if a[i,i] = FAIL then
                                error("invalid function call, unable to convert")
                            end_if
                        end_for;
                        return( new(this,n,n,a) )
                    end_if;

                    a := array(1..n,1..n);
                    for i from 1 to n do
                        for j from 1 to n do
                            a[i,j] := f(t(i,j));
                            if a[i,j] = FAIL then
                                error("invalid function call, unable to convert")
                            end_if
                        end_for
                    end_for;
                    return( new(this,n,n,a) )
                end_if;

                if domtype(t) <> DOM_LIST then
                    t := f(t);
                    if t = FAIL then
                        error("invalid argument, unable to convert")
                    end_if;
                    if l = 1 then
                        return( new(this,n,n,array(1..n,1..n,[[t $ n] $ n])) )
                    else
                        return( new(this,n,n,array(1..n,1..n,
                            [[Rzero $ i-1, t, Rzero $ n-i] $ i=1..n]))
                              )
                    end_if
                end_if;

                if l = 1 then
                    t := this::mkDense( n,n,t );
                    if t <> FAIL then return( new(this,op(t)) ) end_if;
                    error("invalid type of list or unable to convert")
                end_if;
                # define diagonal matrix from list #
                a := array( 1..n,1..n,[ [Rzero $ n] $ n ] );
                for i from 1 to min(n,nops(t)) do
                    a[i,i] := f(t[i]);
                    if a[i,i] = FAIL then
                        error("invalid entries, unable to convert")
                    end_if
                end_for;
                return( new( this,n,n,a ) )
        end_case
    end_proc,
# #
# convert() #
    "convert" = proc(e)
	local t;
    begin
	if domtype(e) = this then return( e ) end_if;
	t := domattr(Matrix(R),"convert")( e );
	if t = FAIL then return( FAIL ) end_if;
	if t::dimen(t) <> [n,n] then
	    return( FAIL )
	else
	    extsubsop( t,0=this )
	end_if
    end_proc,
# #
# the one #
    "one" = (if Rone <> FAIL then
	new( this,n,n,
	  array(1..n,1..n,[[Rzero $ i-1,Rone,Rzero $ n-i] $ hold(i)=1..n])
	   )
    end_if),
# #
# the zero #
    "zero" = new( this,n,n,
	array( 1..n,1..n,[ [Rzero $ n] $ n ] ) ),
# #
# dimen #
    "dimen" = [n,n],
# #
# delRow #
    "delRow" = domattr(Matrix(R),"delRow"),
# #
# delCol #
    "delCol" = domattr(Matrix(R),"delCol"),
# #
# stackMatrix #
    "stackMatrix" = domattr(Matrix(R),"stackMatrix"),
# #
# concatMatrix #
    "concatMatrix" = domattr(Matrix(R),"concatMatrix"),
# #
# row #
    "row" = domattr(Matrix(R),"row"),
# #
# col #
    "col" = domattr(Matrix(R),"col"),
# #
    "randomDimen" = [n,n],
# #
# random() #
# returns a n times n random matrix #
    "random" = (if R::random <> FAIL then
            fun( new( this,n,n,array( 1..n,1..n,
                [[R::random() $ hold(j)=1..n] $ hold(i)=1..n]
            )) )
    end_if)
):

