# $Date: 1995/07/17 09:36:47 $ $Author: kg $ $Revision: 1.29.2.2 $ #
#++
Polynomial -- the domain of polynomials

Polynomial(R)

R - coefficient ring (commutative ring)

Polynomials have one operand: A distributed polynomial of basic type
DOM_POLY. The elements of this domain may have different lists of
indeterminates.

The canonical representation is assured as follows:
- If the degree of a Polynomial is 0, the operand has only one
  indet (_x).
- An operand has always a sorted list of indets, indets with degree 0
  don't exist in the indets list.

Methods:
normalize(p) - converts DOM_POLY p into normal form of this domain
	(p is supposed to have the same coeff. ring as this domain)
adaptIndets(p...) - adapts the indets lists of the operands of the
	Polynomials p... such that they are equal and returns the new
	polynomials as DOM_POLY's
poly(p,X,R) - converts a polynomial p from this domain into a DOM_POLY
	with variables X and coeff. ring R
++#

Polynomial:= DomainConstructor(
    Polynomial,
    [ R ],
    [ ],
    ( if args(0) <> 1 then error("wrong no of args") end_if;
      if R::hasProp(CommutativeRing) <> TRUE then
          error("no commutative ring")
      end_if ),

    BaseDomain,
    [ PolynomialCat(R) ],
    [ ( if R::hasProp(canonicalRep) then canonicalRep 
        else normalRep end_if ) ],

    # converts DOM_POLY x into normal form of this domain. x is supposed
      to have coeff. ring R and a sorted list of indeterminates. #
    "normalize" = ( if R::hasProp(normalRep) then
	fun((if iszero(args(1)) then
		 this::zero
	     else
		 new(this, args(1))
	     end_if))
    else
	proc(x) begin
	    x:= mapcoeffs(x,
		    fun((
			if R::iszero(args(1)) then R::zero else args(1) end_if
		    )));
	    if iszero(x) then
		this::zero
	    else
		new(this, x)
	    end_if
	end_proc
    end_if ),

    "convert" = (if R = Integer then
        proc(x) begin
	    case domtype(x)
	    of this do return(x);
	    of DOM_INT do
		x:= poly(x, [hold(_x)], hold(Expr));
		break;
	    otherwise
		x:= poly(x, hold(Expr));
	    end_case;
	    if map({coeff(x), 1}, domtype) <> {DOM_INT} then
		return(FAIL)
	    end_if;
	    this::normalize(x);
        end_proc
    elif R = Rational then
        proc(x) begin
	    case domtype(x)
	    of this do return(x);
	    of DOM_INT do
	    of DOM_RAT do
		x:= poly(x, [hold(_x)], hold(Expr));
		break;
	    otherwise
		x:= poly(x, hold(Expr));
	    end_case;
	    if map({coeff(x), 1, 1/2}, domtype) <> {DOM_INT, DOM_RAT} then
		return(FAIL)
            end_if;
	    this::normalize(x);
        end_proc
    elif R::hasProp(systemRep) and R::hasProp(normalRep) then
        proc(x) local c, i; begin
	    if domtype(x) = this then return(x) end_if;
	    c:= R::convert(x);
	    if c = FAIL then
		case type(x)
		of "_plus" do
		    return(this::_plus(this::convert(op(x,i)) $ i=1..nops(x)));
		of "_mult" do
		    return(this::_mult(this::convert(op(x,i)) $ i=1..nops(x)));
		of "_power" do
		    return(this::_power(this::convert(op(x,1)), op(x,2)));
		otherwise
		    c:= poly(x);
		    if c = FAIL then return(FAIL) end_if;
		    if contains(op(c,2), x) = 0 then return(FAIL) end_if;
		    x:= poly(x, [x]);
		end_case;
	    else
		x:= poly(c, [hold(_x)]);
	    end_if;
	    if x = FAIL then return(FAIL) end_if;
	    this::normalize(x);
        end_proc
    elif R::constructor = IntegerMod then
        proc(x) local c; begin
	    if domtype(x) = this then return(x) end_if;
	    c:= R::convert(x);
	    if c = FAIL then
		x:= poly(mapcoeffs(mapcoeffs(poly(x, hold(Expr)),
					     R::convert),
				   extop, 1),
			 hold(IntMod)((R::constructor_args)[1]));
	    else
		x:= poly(R::expr(c), [hold(_x)],
			 hold(IntMod)((R::constructor_args)[1]))
	    end_if;
	    if x = FAIL then return(FAIL) end_if;
	    this::normalize(x);
        end_proc
    else
        proc(x) local c, i; begin
	    if domtype(x) = this then return(x) end_if;
	    c:= R::convert(x);
	    if c = FAIL then
		case type(x)
		of "_plus" do
		    return(this::_plus(this::convert(op(x,i)) $ i=1..nops(x)));
		of "_mult" do
		    return(this::_mult(this::convert(op(x,i)) $ i=1..nops(x)));
		of "_power" do
		    return(this::_power(this::convert(op(x,1)), op(x,2)));
		otherwise
		    c:= poly(x);
		    if c = FAIL then return(FAIL) end_if;
		    if contains(op(c,2), x) = 0 then return(FAIL) end_if;
		    x:= poly(x, [x], R);
		end_case;
	    else
		x:= poly(c, [hold(_x)], R);
	    end_if;
	    if x = FAIL then return(FAIL) end_if;
	    this::normalize(x);
	end_proc
    end_if),

    "expr" = fun( expr(extop(args(1),1)) ),

    "poly" = fun( poly(extop(args(1),1), args(i) $ hold(i)=2..args(0)) ),

    "TeXindet" = fun( "{".expr2text(args(1))."}" ),

    "TeX" = proc(x) local i, j, d, s, ind, nind; begin
	x:= extop(x,1);
        if iszero(x) then
            R::TeX(R::zero)
        else
	    ind:=map(op(x,2), this::TeXindet);
	    nind:= nops(ind);
            d:= degreevec(lterm(x));
            if _plus(op(d)) = 0 or not R::equal(lcoeff(x), R::one) then
                s:= "{".R::TeX(lcoeff(x))."}";
            else
                s:= "";
            end_if;
            for i from 1 to nind do
                if d[i] = 1 then
                    s:= s.ind[i]
                elif d[i] > 0 then
                    s:= s.ind[i]."^{".expr2text(d[i])."}"
                end_if;
            end_for;
            for j from 2 to nterms(x) do
                d:= degreevec(nthterm(x,j));
                if _plus(op(d)) = 0 or not R::equal(nthcoeff(x,j), R::one) then
                    s:= s." + {".R::TeX(nthcoeff(x,j))."}";
                else
                    s:= s." + ";
                end_if;
                for i from 1 to nind do
                    if d[i] = 1 then
                        s:= s.ind[i]
                    elif d[i] > 0 then
                        s:= s.ind[i]."^{".expr2text(d[i])."}"
                    end_if;
                end_for;
            end_for;
            s
        end_if
    end_proc,

    "zero" = ( if R::hasProp(systemRep) and R::hasProp(normalRep) then
	new(this, poly(R::zero, [hold(_x)], hold(Expr)))
    elif R::constructor = IntegerMod then
	new(this, poly(0, [hold(_x)], hold(IntMod)((R::constructor_args)[1])))
    else
	new(this, poly(R::zero, [hold(_x)], R))
    end_if ),

    "one" = ( if R::hasProp(systemRep) and R::hasProp(normalRep) then
	new(this, poly(R::one, [hold(_x)], hold(Expr)))
    elif R::constructor = IntegerMod then
	new(this, poly(1, [hold(_x)], hold(IntMod)((R::constructor_args)[1])))
    else
	new(this, poly(R::one, [hold(_x)], R))
    end_if ),

    "iszero" = fun( iszero(extop(args(1),1)) ),

    "invert" = ( if R::constructor = IntegerMod then
    	proc(x) begin
	    x:= extop(x,1);
            if degree(x) > 0 then return(FAIL) end_if;
            x:= R::convert(1/lcoeff(x));
            if x = FAIL then FAIL else this::convert(x) end_if;
    	end_proc
    else
    	proc(x) begin
	    x:= extop(x,1);
            if degree(x) > 0 then return(FAIL) end_if;
            x:= R::invert(lcoeff(x));
            if x = FAIL then FAIL else this::convert(x) end_if;
    	end_proc
    end_if ),

    "intmult" = ( if R::constructor = IntegerMod then
    	fun( this::normalize(multcoeffs(extop(args(1),1), args(2))) )
    else
        fun( this::normalize(mapcoeffs(extop(args(1),1), R::intmult, args(2))) )
    end_if ),
    
    "divex" = proc(x,y) begin
	x:= divide(this::adaptIndets(x,y), hold(Exact));
	if x = FAIL then return(FAIL) end_if;
	this::normalize(x)
    end_proc,

    "gcd" = (if R = Integer or R = Rational then
	fun( this::normalize(gcd(this::adaptIndets(args()))) )
    elif R::constructor = IntegerMod and R::hasProp(Field) then
	fun( this::normalize(gcd(this::adaptIndets(args()))) )
    elif R::hasProp(GcdDomain) then
	fun( this::normalize(gcd(this::adaptIndets(args()))) )
    end_if),

    "lcm" = (if R = Integer or R = Rational then
	fun( this::normalize(lcm(this::adaptIndets(args()))) )
    elif R::constructor = IntegerMod and R::hasProp(Field) then
	fun( this::normalize(lcm(this::adaptIndets(args()))) )
    elif R::hasProp(GcdDomain) then
	fun( this::normalize(lcm(this::adaptIndets(args()))) )
    end_if),

    "Factor" = (if R = Integer or R = Rational then
	proc(x) local f, i; begin
	    x:= extop(x,1);
	    f:= factor(x);
	    [ this::normalize(poly(f[1], op(x,2..3))),
	      (this::normalize(f[2*i]), f[2*i+1]) $i=1..((nops(f)-1) div 2) ]
	end_proc
    elif R::constructor = IntegerMod and R::hasProp(Field) then
	proc(x) local u, i, f; begin
	    u:= this::indets(x);
	    if nops(u) > 1 then error("not yet implemented") end_if;
	    x:= extop(x,1);
	    f:= factor(poly(x, u, op(x,3)));
	    [ this::normalize(poly(f[1], u, op(x,3))),
	      (this::normalize(f[2*i]), f[2*i+1]) $i=1..((nops(f)-1) div 2) ]
	end_proc
    end_if),

    "sqrFree" = (if R = Integer or R = Rational then
	proc(x) local f, i; begin
	    x:= extop(x,1);
	    f:= sqrfree(x);
	    [ this::normalize(poly(f[1], op(x,2..3))),
	      (this::normalize(f[2*i]), f[2*i+1]) $i=1..((nops(f)-1) div 2) ]
	end_proc
    elif R::constructor = IntegerMod and R::hasProp(Field) then
	proc(x) local u, i, f; begin
	    u:= this::indets(x);
	    if nops(u) > 1 then error("not yet implemented") end_if;
	    x:= extop(x,1);
	    f:= sqrfree(poly(x, u, op(x,3)));
	    [ this::normalize(poly(f[1], u, op(x,3))),
	      (this::normalize(f[2*i]), f[2*i+1]) $i=1..((nops(f)-1) div 2) ]
	end_proc
    end_if),

    "indets" = proc(p) local ind, i; begin
	p:= extop(p,1);
	ind:= op(p,2);
	[ (if degree(p,ind[i]) = 0 then null() else ind[i] end_if)
	  $ i=1..nops(ind) ]
    end_proc,

    "mainvar" = fun( this::indets(args(1))[1] ),

    "degree" = fun((
	if args(0) = 1 then
	    degree(extop(args(1),1))
	elif contains(op(extop(args(1),1),2), args(2)) = 0 then
	    0
	else
	    degree(extop(args(1),1), args(2))
	end_if )),

    "degreevec" = fun((
	if degree(extop(args(1),1)) = 0 then
	    []
	else
	    degreevec(poly(lterm(extop(args(1),1)), this::indets(args(1)),
			   op(extop(args(1),1),3)))
	end_if )),

    "lcoeff" = ( if R::constructor = IntegerMod then
    	fun( R::convert(lcoeff(extop(args(1),1))) )
    else
    	fun( lcoeff(extop(args(1),1)) )
    end_if ),

    "lmonomial" = fun( this::normalize(lmonomial(extop(args(1),1))) ),

    "lterm" = fun( this::normalize(lterm(extop(args(1),1))) ),

    "nterms" = fun( nterms(extop(args(1),1)) ),

    "nthcoeff" = ( if R::constructor = IntegerMod then
    	fun( R::convert(nthcoeff(extop(args(1),1), args(2))) )
    else
    	fun( nthcoeff(extop(args(1),1), args(2)) )
    end_if ), 

    "nthterm" = fun( this::normalize(nthterm(extop(args(1),1), args(2))) ),

    "nthmonomial" = fun(
	this::normalize(nthmonomial(extop(args(1),1), args(2))) ),

    "tcoeff" = ( if R::constructor = IntegerMod then
    	fun( R::convert(tcoeff(extop(args(1),1))) )
    else
    	fun( tcoeff(extop(args(1),1)) )
    end_if ),

    "coeff" = ( if R::constructor = IntegerMod then
    	proc(p,x,n) begin
	    p:= extop(p,1);
	    case args(0)
	    of 1 do return(op(map([coeff(p)], R::convert)));
	    of 2 do x:= coeff(p,x); break;
	    of 3 do x:= coeff(p,x,n); break;
	    otherwise error("wrong no of args")
	    end_case;
	    if nops(op(p,2)) = 1 then
	    	R::convert(x)
	    else
	    	this::normalize(x)
	    end_if
    	end_proc
    else
    	proc(p,x,n) begin
	    p:= extop(p,1);
	    case args(0)
	    of 1 do return(coeff(p));
	    of 2 do x:= coeff(p,x); break;
	    of 3 do x:= coeff(p,x,n); break;
	    otherwise error("wrong no of args")
	    end_case;
	    if nops(op(p,2)) = 1 then
	    	x
	    else
	    	this::normalize(x)
	    end_if
    	end_proc
    end_if) ,

    "multcoeffs" = ( if R::constructor = IntegerMod then 
    	fun( this::normalize(multcoeffs(extop(args(1),1), extop(args(2), 1))) )
    else
    	fun( this::normalize(multcoeffs(extop(args(1),1), args(2))) )
    end_if ),

    "evalp" = (if R::hasProp(systemRep) and R::hasProp(normalRep) then
	proc(p) begin
	    p:= evalp(extop(p,1), args(i) $ hold(i)=2..args(0));
	    if domtype(p) = DOM_POLY then this::normalize(p) else p end_if
	end_proc
    elif R::constructor = IntegerMod then
	proc(p) begin
	    p:= evalp(extop(p,1), (op(args(i),1) = extop(op(args(i),2),1)) 
	    				$ hold(i)=2..args(0));
	    if domtype(p) = DOM_POLY then this::normalize(p)
	    else R::convert(p) end_if
	end_proc
    else
	proc(p) begin
	    p:= evalp(extop(p,1), args(i) $ hold(i)=2..args(0));
	    if domtype(p) = R then p else this::normalize(p) end_if
	end_proc
    end_if),

    "mapcoeffs" = ( if R::constructor = IntegerMod then
        fun(this::normalize(poly(mapcoeffs(poly(extop(args(1),1), R),
                                           args(i) $ hold(i)=2..args(0)),
                            hold(IntMod)((R::constructor_args)[1]))))

    else
    	fun( this::normalize(mapcoeffs(extop(args(1),1),
				  args(i) $ hold(i)=2..args(0))) )
    end_if ),

    "content" = (if R = Integer then
        fun( icontent(extop(args(1),1)) )
    end_if),

    "primpart" = (if R = Integer then
        proc(x) begin
	    x:= extop(x,1);
            this::unitNormal(this::normalize(multcoeffs(x, 1/icontent(x))))
        end_proc
    end_if),

    "unitNormal" = (if R = Integer then
        proc(x) begin
            if iszero(extop(x,1)) then
                this::zero
            elif sign(lcoeff(extop(x,1))) = 1 then
		x
	    else
		new(this, multcoeffs(extop(x,1), -1))
	    end_if
        end_proc
    elif R = Rational or
	 (R::constructor = IntegerMod and R::hasProp(Field)) then
        proc(x) begin
	    x:= extop(x,1);
	    if iszero(x) then return(this::zero) end_if;
            this::normalize(multcoeffs(x, 1/lcoeff(x)))
        end_proc
    end_if),

    "unitNormalRep" = (if R = Integer then
        proc(x) local o; begin
            o:= this::one;
	    if iszero(extop(x,1)) then
		[ this::zero, o, o ]
            elif sign(lcoeff(extop(x,1))) = 1 then
		[ x, o, o ]
	    else
		o:= this::negate(o);
		[ new(this, multcoeffs(extop(x,1), -1)), o, o ]
	    end_if;
        end_proc
    elif R = Rational or
         (R::constructor = IntegerMod and R::hasProp(Field)) then
        proc(x) local l; begin
	    x:= extop(x,1);
	    if iszero(x) then
		return([this::zero, this::one, this::one])
	    end_if;
            l:= lcoeff(x);
            [ this::normalize(multcoeffs(x, 1/l)),
	      new(this, poly(1/l, [hold(_x)], op(x,3))),
	      new(this, poly(l, [hold(_x)], op(x,3))) ]
        end_proc
    end_if),

    "D" = proc(l,p) local i, ind; begin
	if args(0) = 1 then
	    p:= args(1); l:= [1]
	elif l = [] then
	    return(p)
	end_if;

	p:= extop(p,1);
	ind:= op(p,2);
	ind:= [ (if degree(p,ind[i]) = 0 then null() else i end_if)
	      $ i=1..nops(ind) ];
	if max(op(l)) > nops(ind) then return(this::zero) end_if;
	this::normalize(Dpoly([ ind[l[i]] $ i=1..nops(l) ], p))
    end_proc,

    "negate" = fun( new(this, -extop(args(1),1)) ),

    # adaptIndets -- converts the DOM_POLY's of its arguments such that
      they have a common list of indets. The arguments are from this domain.
      The result are the converted DOM_POLY's. #
    "adaptIndets" = proc() local p, i, ind, r; begin
	p:= extop(args(i),1) $ i=1..args(0);
	ind:= { op(p[i],2) $ i=1..args(0) };
	if nops(ind) = 1 then return(p) end_if;
	ind:= sort([ op(map(ind, op)) ]);
	r:= op(p[1],3);
	(poly(p[i], ind, r) $ i=1..args(0));
    end_proc,

    "_plus" = fun((
	if args(0) = 1 then return(args(1)) end_if;
	if map({args()}, domtype) <> {this} then return(FAIL) end_if;
	this::normalize(_plus(this::adaptIndets(args()))) )),

    "minus" = proc(x,y) begin
	x:= this::adaptIndets(x,y);
	this::normalize(x[1] - x[2])
    end_proc,

    "_mult" = (if R::hasProp(systemRep) then
        fun((if args(0) = 2 then
    	    if domtype(args(2)) <> this then
    	    	if domtype(args(2)) = DOM_INT then
    	    	    this::intmult(args())
    	    	elif testtype(args(2), R) then
    	    	    this::multcoeffs(args(1), R::convert(args(2)))
    	    	else
    	    	    (domtype(args(2)))::_mult(args())
    	    	end_if
    	    elif domtype(args(1)) <> this then
    	    	if domtype(args(1)) = DOM_INT then
    	    	    this::intmult(args(2), args(1))
    	    	elif testtype(args(1), R) then
    	    	    this::multcoeffs(args(2), R::convert(args(1)))
    	    	else
    	    	    FAIL
    	    	end_if
    	    else
    	        this::normalize(_mult(this::adaptIndets(args())))
    	    end_if
    	elif args(0) = 1 then
    	    args(1)
    	else
    	    _mult(args(i) $ hold(i)=1..(args(0) div 2));
    	    _mult(args(i) $ hold(i)=((args(0) div 2) + 1)..args(0));
    	    _mult(%1, %2)
    	end_if))
    else
        fun((if args(0) = 2 then
    	    if domtype(args(2)) <> this then
    	    	case domtype(args(2))
    	    	of DOM_INT do this::intmult(args()); break;
    	    	of R do this::multcoeffs(args()); break;
    	    	otherwise (domtype(args(2)))::_mult(args());
    	    	end_case
    	    elif domtype(args(1)) <> this then
    	    	case domtype(args(1))
    	    	of DOM_INT do this::intmult(args(2), args(1)); break;
    	    	of R do this::multcoeffs(args(2), args(1)); break;
    	    	otherwise FAIL;
    	    	end_case
    	    else
    	        this::normalize(_mult(this::adaptIndets(args())))
    	    end_if
    	elif args(0) = 1 then
    	    args(1)
    	else
    	    _mult(args(i) $ hold(i)=1..(args(0) div 2));
    	    _mult(args(i) $ hold(i)=((args(0) div 2) + 1)..args(0));
    	    _mult(%1, %2)
    	end_if))
    end_if),

    "_power" = fun( this::normalize(_power(extop(args(1),1), args(2))) ),

    "pivotSize" = this::degree,

    "random" = (if R = Integer or R = Rational then
        fun(this::normalize(randpoly([hold(x)], hold(Expr))))
    elif R::hasProp(systemRep) then
        fun(this::normalize(randpoly([hold(x)], hold(Expr), hold(Coeffs)=R::random)))
    elif R::constructor = IntegerMod then
        fun(this::normalize(
        	new(this, randpoly([hold(x)], hold(IntMod)((R::constructor_args)[1])))))
    else
        fun(this::normalize(randpoly([hold(x)], R)))
    end_if)

):

# end of file #

