# domains of intervals: Interval(a..b) represents the interval [a,b].
  It forms a field, but the representation of zero is not unique
  (any interval [a,b] such that a<=0<=b represents 0).

  The available methods are:
  _plus, sign, _mult, negate, invert, _power, iszero, convert,
  random, exp, _union, _intersect.
#

Interval := DomainConstructor(
# name #
    Interval,
# arguments #
    [ ],
# local variables #
    [ ],
# initialisation #
    (if args(0) <> 0 then error("wrong no of args") end_if),
# super-domains #
    BaseDomain,
# categories #
    [ Field ],
# axioms #
    [ ],
# methods #
    "characteristic" = 0,
    
    "expr" = fun(hold(_range)(extop(args(1)))),
  
    "convert" = fun((
       case domtype(args(1))
       of this do return(args(1))
       of DOM_INT do
       of DOM_RAT do
       of DOM_FLOAT do return(new(this,args(1),args(1)))
       of DOM_EXPR do
	   if testtype(args(1), hold(_range)(Type::RealNum, Type::RealNum)) then
	       return(new(this, min(op(args(1))), max(op(args(1)))))
	   end_if;
       end_case;
       FAIL
    )),

    "_plus" = proc(r) local i,s,t; begin
        i:=this::convert(r);
        if i=FAIL then t:=r; r:=this::zero else r:=i; t:=0 end_if;
        for i from 2 to args(0) do
           s:=this::convert(args(i));
           if s=FAIL then t:=t+args(i)
	   else r:=new(this,extop(r,1)+extop(s,1),extop(r,2)+extop(s,2))
           end_if
        end_for;
        if t=0 then r else hold(_plus)(t,r) end_if
    end_proc,

    "sign" = proc(r) begin 
	if extop(r,1)>0 then 1 elif extop(r,2)<0 then -1 else 0 end_if
    end_proc,

    "_mult" = proc(r) local a,b,c,d,s,i,t; begin
        a:=this::convert(r);
        if a=FAIL then t:=r; r:=this::one else r:=a; t:=1 end_if;
        for i from 2 to args(0) do
	   s:=this::convert(args(i));
           if s=FAIL then t:=t*args(i)
           else
	      a:=extop(r,1); b:=extop(r,2); c:=extop(s,1); d:=extop(s,2);
	      case this::sign(r),this::sign(s)
	      of 1,1 do r:=new(this,a*c,b*d); break
	      of 1,0 do r:=new(this,b*c,b*d); break
	      of 1,-1 do r:=new(this,b*c,a*d); break
	      of 0,1 do r:=new(this,a*d,b*d); break
	      of 0,0 do r:=new(this,min(a*d,b*c),max(a*c,b*d)); break
	      of 0,-1 do r:=new(this,b*c,a*c); break
	      of -1,1 do r:=new(this,a*d,b*c); break
	      of -1,0 do r:=new(this,a*d,a*c); break
	      of -1,-1 do r:=new(this,b*d,a*c)
	      end_case
           end_if
        end_for;
        if t=1 then r else hold(_mult)(t,r) end_if
    end_proc,

    "negate" = proc(r) begin new(this,-extop(r,2),-extop(r,1)) end_proc,

    "invert" = proc(r) begin
	if this::sign(r)=0 then error("division by zero")
	else new(this,1/extop(r,2),1/extop(r,1))
	end_if
    end_proc,

    "_power" = proc(r,n) local a,b; begin
	if n<0 then 1/r^(-n)
	elif n=1 then r
	else
           a:=extop(r,1)^n; b:=extop(r,2)^n;
           case this::sign(r)
           of 1 do return(new(this,a,b))
           of 0 do
              if n mod 2 = 0 then new(this,0,max(a,b))
              else new(this,a,b)
              end_if; break
           of -1 do if a<b then new(this,a,b) else new(this,b,a) end_if
           end_case
        end_if
    end_proc,

    "iszero" = fun(
	bool(iszero(extop(args(1),1)) and iszero(extop(args(1),2)))
    ),

    "random" = proc() local a,b; begin 
       a:=tan(float(PI) * (random()/(10.0^12) - 0.5)); # -infinity < a < infinity #
       b:=tan(float(PI/2) * (random()/(10.0^12))); # 0 <= b < infinity #
       new(this,a,a+b)
    end_proc,

    "one" = new(this,1,1),

    "zero" = new(this,0,0),
    
    "exp" = fun(new(this,exp(float(extop(args(1),1))),
	exp(float(extop(args(1),2))))),

    "_union" = proc() begin
       if args(0)=0 then error("wrong number of arguments") end_if;
       new(this,min(map(args(),extop,1)),max(map(args(),extop,2)))
    end_proc,

    "_intersect" = proc() begin
       if args(0)=0 then error("wrong number of arguments") end_if;
       new(this,max(map(args(),extop,1)),min(map(args(),extop,2)))
    end_proc
)():
