# $Date: 1995/06/28 10:01:50 $ $Author: kg $ $Revision: 1.12.2.1 $
#
#++
Expression -- the domain of expressions

The domain of expressions formed by basic domains like DOM_INT or
DOM_EXPR built up by the internal operators.

Expressions are not represented explicitly but rather as elements
basic domain elements built into the MuPAD kernel.

Methods:-
convert(e)      - convert the expression e into an Expression, ie. e itself
convert_to(e,D) - convert Expression e into element of domain D
expr(e)         - convert Expression e into an expression, ie. into e itself
testtype(e,D)   - test if e is an Expression
equal(x,y)	- tests if two Expressions are equal
TeX(x)		- returns TeX(x) (with the library function TeX)
subs(x,...)	- is equal to the kernel function subs
subsex(x,...)	- is equal to the kernel function subsex
random()	- returns a random rational expression
++#

Expression:= DomainConstructor(

    Expression,
    [ ],
    [ ],
    NIL,
    BaseDomain,
    [ SetCat ],
    [ systemRep ],

    "convert" = expr,

    "convert_to" = proc(x,T) begin
	if T = this then x else FAIL end_if
    end_proc,

    "expr" = id,

    "testtype" = proc(x,T) begin
        # there are no elements x of 'this', so T must be 'this' #
	if this::convert(x) = FAIL then FAIL else TRUE end_if
    end_proc,

    "equal" = bool @ _equal,

    "TeX" = TeX,

    "subs" = subs,

    "subsex" = subsex,

    "random" = fun((
        randpoly([hold(x)], hold(Expr));
        if iszero(%) then 0
        else expr(randpoly([hold(x)], hold(Expr))) / expr(%)
        end_if
    ))

)():

