# $Date: 1995/07/17 09:36:43 $ $Author: kg $ $Revision: 1.29.2.2 $ #
#++
DistributedPolynomial -- domain of distributed polynomials

DistributedPolynomial(Ind,R)

Ind - list of indeterminates
R   - coefficient ring

Distributed polynomials over rings other than 'IntegerMod' are
represented as expressions of type DOM_POLY. Therefore the ring R
must have 'normalRep', otherwise the function 'iszero' would not
work correctly.

Methods:-
poly(p,X,R) - converts a polynomial p from this domain into a DOM_POLY
	with variables X and coeff. ring R
++#

DistributedPolynomial:= DomainConstructor(
    DistributedPolynomial,
    [ Ind, R ],
    [ NumInd ],
    ( if args(0) <> 2 then error("wrong no of args") end_if;
      if R::hasProp(CommutativeRing) <> TRUE then
	  error("no commutative ring")
      end_if;
      if not R::hasProp(normalRep) then
	  error("ring has no normal form")
      end_if;
      if traperror(poly(1,Ind)) <> 0 then
	  error("illegal indeterminates")
      end_if;
      if poly(1,Ind) = FAIL then
	  error("illegal indeterminates")
      end_if;
      NumInd:= nops(Ind) ),

    (if R::constructor = IntegerMod then BaseDomain
     else ArithmeticalExpression end_if),
    [ ( if NumInd = 1 then
	    UnivariatePolynomialCat(R)
	else
	    PolynomialCat(R)
	end_if ) ],
    [ (if R::constructor <> IntegerMod then systemRep end_if),
      ( if R::hasProp(canonicalRep) then
	    canonicalRep
	else
	    normalRep
	end_if ) ],

    "convert" = (if R = Integer then
	proc(x) begin
	    x:= poly(x, hold(Ind), hold(Expr));
	    if x <> FAIL then
		if map({coeff(x), 1}, domtype) <> {DOM_INT} then
		    x:= FAIL
		end_if
	    end_if;
	    x
	end_proc
    elif R = Rational then
	proc(x) begin
	    x:= poly(x, hold(Ind), hold(Expr));
	    if x <> FAIL then
		if map({coeff(x), 1, 1/2}, domtype) <> {DOM_INT, DOM_RAT} then
		    x:= FAIL
		end_if
	    end_if;
	    x
	end_proc
    elif R::hasProp(systemRep) then
	proc(x) begin
	    x:= poly(x, hold(Ind), hold(Expr));
	    if x <> FAIL then
		x:= mapcoeffs(x, R::convert);
	    end_if;
	    x
	end_proc
    elif R::constructor = IntegerMod then
	proc(x) begin
	    x:= poly(mapcoeffs(mapcoeffs(poly(x, hold(Ind), hold(Expr)),
					 R::convert),
			       extop, 1),
		     hold(IntMod)((R::constructor_args)[1]));
	    if x = FAIL then x else new(this, x) end_if
	end_proc
    else
	proc(x) begin poly(x, hold(Ind), R) end_proc
    end_if),

    "expr" = (if R::constructor = IntegerMod then
	fun(expr(extop(args(1),1)))
    else
	expr
    end_if),

    "poly" = (if R::constructor = IntegerMod then
	fun(poly(extop(args(1),1), args(i) $ hold(i)=2..args(0)))
    else
	poly
    end_if),

    "TeXindet" = proc(x) begin
	"{".expr2text(x)."}"
    end_proc,

    "TeX" = proc(x) local i, j, d, s; begin
	if iszero(x) then
	    R::TeX(R::zero)
	else
	    d:= degreevec(lterm(x));
	    if _plus(op(d)) = 0 or not R::equal(lcoeff(x), R::one) then
		s:= "{".R::TeX(lcoeff(x))."}";
	    else
		s:= "";
	    end_if;
	    for i from 1 to NumInd do
		if d[i] = 1 then
		    s:= s.this::TeXindet(hold(Ind)[i])
		elif d[i] > 0 then
		    s:= s.this::TeXindet(hold(Ind)[i])."^{".
			expr2text(d[i])."}"
		end_if;
	    end_for;
	    for j from 2 to nterms(x) do
		d:= degreevec(nthterm(x,j));
		if _plus(op(d)) = 0 or not R::equal(nthcoeff(x,j), R::one) then
		    s:= s." + {".R::TeX(nthcoeff(x,j))."}";
		else
		    s:= s." + ";
		end_if;
		for i from 1 to NumInd do
		    if d[i] = 1 then
			s:= s.this::TeXindet(hold(Ind)[i])
		    elif d[i] > 0 then
			s:= s.this::TeXindet(hold(Ind)[i])."^{".
				expr2text(d[i])."}"
		    end_if;
		end_for;
	    end_for;
	    s
	end_if
    end_proc,

    "zero" = this::convert(R::zero),

    "one" = this::convert(R::one),

    "iszero" = (if R::constructor = IntegerMod then
	fun(iszero(extop(args(1),1)))
    end_if),

    "_plus" = (if R::constructor = IntegerMod then
	fun((if map({args()}, domtype) <> {this} then FAIL
	     else new(this, _plus(extop(args(i),1) $ hold(i)=1..args(0)))
	     end_if))
    end_if),

    "minus" = (if R::constructor = IntegerMod then
	fun(new(this, extop(args(1),1) - extop(args(2),1)))
    end_if),

    "negate" = (if R::constructor = IntegerMod then
	fun(new(this, - extop(args(1),1)))
    end_if),

    "_mult" = (if R::constructor = IntegerMod then
        fun((if args(0) = 2 then
    	    if domtype(args(2)) <> this then
    	    	case domtype(args(2))
    	    	of DOM_INT do this::intmult(args()); break;
    	    	of R do this::multcoeffs(args()); break;
    	    	otherwise (domtype(args(2)))::_mult(args());
    	    	end_case
    	    elif domtype(args(1)) <> this then
    	    	case domtype(args(1))
    	    	of DOM_INT do this::intmult(args(2), args(1)); break;
    	    	of R do this::multcoeffs(args(2), args(1)); break;
    	    	otherwise FAIL;
    	    	end_case
    	    else
    	        new(this, extop(args(1),1) * extop(args(2),1))
    	    end_if
    	elif args(0) = 1 then
    	    args(1)
    	else
    	    _mult(args(i) $ hold(i)=1..(args(0) div 2));
    	    _mult(args(i) $ hold(i)=((args(0) div 2) + 1)..args(0));
    	    _mult(%1, %2)
    	end_if))
    end_if),

    "_power" = (if R::constructor = IntegerMod then
	fun(new(this, extop(args(1),1) ^ args(2)))
    end_if),

    "invert" = proc(x) begin
	if degree(x) > 0 then return(FAIL) end_if;
	x:= R::invert(lcoeff(x));
	if x = FAIL then FAIL else this::convert(x) end_if;
    end_proc,

    "intmult" = (if R::constructor = IntegerMod then
	proc(x,i) begin new(this, multcoeffs(extop(x,1), i)) end_proc
    else
	proc(x,i) begin mapcoeffs(x, R::intmult, i) end_proc
    end_if),

    "divex" = (if R::constructor = IntegerMod then
	proc(x,y) begin
	    x:= divide(extop(x,1), extop(y,1), hold(Exact));
	    if x = FAIL then FAIL else new(this, x) end_if
	end_proc
    else
	proc(x,y) begin divide(x, y, hold(Exact)) end_proc
    end_if),

    "euclideanDegree" = (if NumInd = 1 then degree end_if),

    "divide" = (if NumInd = 1 then
	if R::constructor = IntegerMod then
	    proc(x,y,o) begin
		if args(0) = 2 then
		    x:= divide(extop(x,1), extop(y,1));
		else
		    x:= divide(extop(x,1), extop(y,1), o);
		end_if;
		case domtype(x)
		of DOM_POLY do new(this, x); break;
		of DOM_FAIL do FAIL; break;
		otherwise (new(this, x[1]), new(this, x[2]));
		end_case
	    end_proc
	else
	    divide
	end_if
    end_if),
 
    "quo" = (if NumInd = 1 then
	proc(x,y) begin divide(x, y, hold(Quo)) end_proc
    end_if),

    "rem" = (if NumInd = 1 then
	proc(x,y) begin divide(x, y, hold(Rem)) end_proc
    end_if),

    "gcd" = (if R = Integer or R = Rational then
	gcd
    elif R::constructor = IntegerMod and R::hasProp(Field) then
	fun( new(this, gcd(extop(args(i),1) $ hold(i)=1..args(0))))
    elif R::hasProp(GcdDomain) then
	gcd
    end_if),

    "lcm" = (if R = Integer or R = Rational then
	lcm
    elif R::constructor = IntegerMod and R::hasProp(Field) then
	fun( new(this, lcm(extop(args(i),1) $ hold(i)=1..args(0))))
    elif R::hasProp(GcdDomain) then
	lcm
    end_if),

    "Factor" = (if R = Integer or R = Rational then
	factor
    elif R::constructor = IntegerMod and R::hasProp(Field) and NumInd = 1 then
	proc(x) begin
	    x:= factor(extop(x,1));
	    [ R::convert(x[1]),
	      (new(this, x[2*i]), x[2*i+1]) $ hold(i)=1..(nops(x) div 2) ]
	end_proc
    end_if),

    "sqrFree" = (if R = Integer or R = Rational then
	sqrfree
    elif R::constructor = IntegerMod and R::hasProp(Field) and NumInd = 1 then
	proc(x) begin
	    x:= sqrfree(extop(x,1));
	    [ R::convert(x[1]),
	      (new(this, x[2*i]), x[2*i+1]) $ hold(i)=1..(nops(x) div 2) ]
	end_proc
    elif R::hasProp(FactorialDomain) then
        if R::characteristic = 0 then
            sqrfree
        end_if
    end_if),

    "pdivide" = (if NumInd = 1 then
	if R::constructor = IntegerMod then
	    proc(x,y,o) begin
		if args(0) = 2 then
		    x:= pdivide(extop(x,1), extop(y,1));
		    (R::convert(x[1]), new(this, x[2]), new(this, x[3]))
		else
		    new(this, pdivide(extop(x,1), extop(y,1), o))
		end_if;
	    end_proc
	else
	    pdivide
	end_if
    end_if),

    "pquo" = (if NumInd = 1 then
	proc(x,y) begin pdivide(x, y, hold(Quo)) end_proc
    end_if),

    "prem" = (if NumInd = 1 then
	proc(x,y) begin pdivide(x, y, hold(Rem)) end_proc
    end_if),

    "indets" = (if R::constructor = IntegerMod then
	proc(p) begin op(extop(p,1), 2) end_proc
    else
	proc(p) begin op(p,2) end_proc
    end_if),

    "mainvar" = (if R::constructor = IntegerMod then
	proc(p) begin op(extop(p,1),2)[1] end_proc
    else
	proc(p) begin op(p,2)[1] end_proc
    end_if),

    "degree" = (if R::constructor = IntegerMod then
	fun(degree(extop(args(1),1), args(i) $ hold(i)=2..args(0)))
    else
	degree
    end_if),

    "degreevec" = (if R::constructor = IntegerMod then
        fun(degreevec(extop(args(1),1), args(i) $ hold(i)=2..args(0)))
    else
        degreevec
    end_if),

    "lcoeff" = (if R::constructor = IntegerMod then
        fun(R::convert(lcoeff(extop(args(1),1), args(i) $ hold(i)=2..args(0))))
    else
        lcoeff
    end_if),

    "lmonomial" = (if R::constructor = IntegerMod then
        fun(new(this,
	    lmonomial(extop(args(1),1), args(i) $ hold(i)=2..args(0))))
    else
        lmonomial
    end_if),

    "lterm" = (if R::constructor = IntegerMod then
        fun(new(this, lterm(extop(args(1),1), args(i) $ hold(i)=2..args(0))))
    else
        lterm
    end_if),

    "nterms" = (if R::constructor = IntegerMod then
        fun(nterms(extop(args(1),1)))
    else
        nterms
    end_if),

    "nthterm" = (if R::constructor = IntegerMod then
        fun(new(this, nthterm(extop(args(1),1), args(2))))
    else
        nthterm
    end_if),

    "nthcoeff" = (if R::constructor = IntegerMod then
        fun(R::convert( nthcoeff(extop(args(1),1), args(2))))
    else
        nthcoeff
    end_if),

    "nthmonomial" = (if R::constructor = IntegerMod then
        fun(new(this, nthmonomial(extop(args(1),1), args(2))))
    else
        nthmonomial
    end_if),

    "tcoeff" = (if R::constructor = IntegerMod then
        fun(R::convert(tcoeff(extop(args(1),1))))
    else
        tcoeff
    end_if),

    "coeff" = (if R::constructor = IntegerMod then
        proc(p,x,n) begin
            p:= extop(p,1);
            case args(0)
            of 1 do return(op(map([coeff(p)], R::convert)));
            of 2 do x:= coeff(p,x); break;
            of 3 do x:= coeff(p,x,n); break;
            otherwise error("wrong no of args")
            end_case;
            if nops(op(p,2)) = 1 then
                R::convert(x)
            else
		new(this, x)
            end_if
        end_proc
    else
	coeff
    end_if),

    "multcoeffs" = ( if R::constructor = IntegerMod then
        fun(new(this, multcoeffs(extop(args(1),1), extop(args(2),1))))
    else
	multcoeffs
    end_if),

    "evalp" = (if R::constructor = IntegerMod then
        proc(p) begin
            p:= evalp(extop(p,1), (op(args(i),1) = extop(op(args(i),2),1))
                                        $ hold(i)=2..args(0));
            if domtype(p) = DOM_POLY then new(this, p)
            else R::convert(p) end_if
        end_proc
    else
	evalp
    end_if),

    "mapcoeffs" = (if R::constructor = IntegerMod then
        fun(new(this, poly(mapcoeffs(poly(extop(args(1),1), R),
                                          args(i) $ hold(i)=2..args(0)),
                           hold(IntMod)((R::constructor_args)[1]))))
    else
	mapcoeffs
    end_if),

    "content" = (if R = Integer then
	icontent
    end_if),

    "primpart" = (if R = Integer then
	proc(x) begin
	    this::unitNormal(multcoeffs(x, 1/icontent(x)))
	end_proc
    end_if),

    "unitNormal" = (if R = Integer then
	proc(x) begin
	    if iszero(x) then x 
	    elif sign(lcoeff(x)) = 1 then x 
	    else multcoeffs(x, -1) end_if
	end_proc
    elif R = Rational then
	proc(x) begin
	    if iszero(x) then x else multcoeffs(x, 1/lcoeff(x)) end_if
	end_proc
    elif R::constructor = IntegerMod and R::hasProp(Field) then
	proc(x) begin
	    x:= extop(x,1);
	    if iszero(x) then 
		this::zero 
	    else
		new(this, multcoeffs(x, 1/lcoeff(x)))
	    end_if
	end_proc
    end_if),

    "unitNormalRep" = (if R = Integer then
	proc(x) local o; begin
	    o:= poly(1, hold(Ind));
	    if iszero(x) then
	        [ x, o, o ]
	    elif sign(lcoeff(x)) = 1 then
		[ x, o, o ]
	    else
		[ multcoeffs(x, -1),  -o, -o ]
	    end_if
	end_proc
    elif R = Rational then
	proc(x) local l; begin
	    if iszero(x) then
	        [ x, this::one, this::one ]
	    else
		l:= lcoeff(x);
		[ multcoeffs(x, 1/l), poly(1/l,op(x,2..3)), poly(l,op(x,2..3)) ]
	    end_if
	end_proc
    elif R::constructor = IntegerMod and R::hasProp(Field) then
	proc(x) local l; begin
	    x:= extop(x,1);
	    if iszero(x) then
	        [ this::zero, this::one, this::one ]
	    else
		l:= lcoeff(x);
		[ new(this, multcoeffs(x, 1/l)),
		  new(this, poly(1/l,op(x,2..3))),
		  new(this, poly(l,op(x,2..3))) ]
	    end_if
	end_proc
    end_if),

    "D" = (if R::constructor = IntegerMod then
	fun(new(this, (if args(0) = 1 then D(extop(args(1),1))
		       else D(args(1), extop(args(2),1)) end_if)))
    else
	D
    end_if),
    
    "random" = (if R = Integer then
        fun(randpoly(hold(Ind), hold(Expr)))
    elif R::hasProp(systemRep) then
        fun(randpoly(hold(Ind), hold(Expr), hold(Coeffs)=R::random))
    elif R::constructor = IntegerMod then
        fun(new(this, randpoly(hold(Ind), hold(IntMod)((R::constructor_args)[1]))))
    else
        fun(randpoly(hold(Ind), R))
    end_if),
    
    "pivotSize" = this::degree,

    "solve" = (if NumInd=1 and R::constructor = IntegerMod then
	fun([faclib::roots(poly(expr(args(1)),hold(Ind), hold(IntMod)((R::constructor_args)[1])))])
    end_if)

):

