# $Date: 1995/05/26 07:58:45 $ $Author: kg $ $Revision: 1.11 $ #
#++
BaseDomain -- the base domain of the 'domains'-library

Methods:
equal(x,y)	   - tests if x and y are equal (for canonicalRep only)
TeX(x)		   - returns string for object x in TeX-format
subs(x,...)	   - returns x
subsex(x,...)	   - returns x

hasProp(a)         - tests if this domain has super-domain, category, axiom
		     or constructor a
getAxioms()        - returns set with direct axioms
allAxioms()        - returns set with all axioms
getSuperDomain()   - returns direct super-domain
allSuperDomains()  - returns list with all super-domains
getCategories()    - returns list with direct categories
allCategories()    - returns list with all categories
whichEntry(e)      - returns domain or category defining entry e
allEntries()       - returns set with all entry names
undefinedEntries() - returns set with all entrys not defined yet
++#

BaseDomain:= DomainConstructor(
    BaseDomain,
    [],
    [],
    NIL,
    NIL,
    [ SetCat ],
    [],

    "convert_to" = fun((
	case args(2)
	  of this do return(args(1));
	  of Expression do return(this::expr(args(1)));
	end_case;
	FAIL
    )),

    "equal" = (if this::hasProp(canonicalRep) then
	bool @ _equal
    end_if),

    "TeX" = fun(TeX(this::expr(args(1)))),

    "subs" = fun(args(1)),

    "subsex" = fun(args(1)),

    "hasProp" = fun(DomainConstructor::hasProp(this, args(1))),

    "getAxioms" = fun(DomainConstructor::axioms(this)),

    "allAxioms" = fun(this::axioms),

    "getSuperDomain" = fun(this::super_domains[1]),

    "allSuperDomains" = fun(this::super_domains),

    "getCategories" = fun(DomainConstructor::categories(this)),

    "allCategories" = fun(this::categories),

    "whichEntry" = fun(DomainConstructor::whichEntry(this, args(1))),

    "allEntries" = fun(DomainConstructor::allEntries(this)),

    "undefinedEntries" = fun(DomainConstructor::undefinedEntries(this))

)():

