# $Date: 1995/05/19 06:51:36 $ $Author: kg $ $Revision: 1.16 $ #
#++
DomainConstructor -- the domain of domain constructors

A domain constructors is used to create domains depending upon
parameters.

Normally only the method 'new' of the domain 'DomainConstructor' is
called by the domain constructor implementor. The other methods are
called implicitly.

A domain constructor is an element of DomainConstructor with the
following operands:

0 - the domain DomainConstructor
1 - the name of the constructor (a string)
2 - the formal parameters and local variables of the constructor
    (a list of ident's)
3 - a procedure testing the actual parameters and computing the locals
4 - an expression which must evaluate to a domain or NIL
5 - a list of expressions which must evaluate to categories
6 - a list of expressions which must evaluate to axioms
7 - a table with the entries of the domains to construct
8 - a domain containing the domains constructed so far
9 - the number of the formal parameters of the constructor

New domain constructors are created by the method 'new'. I'm very careful not
to evaluate the arg's of 'new' - they will be evaluated when a domain
instance is created later on or when domain entries are to be constructed.

Domain instances are created by the method 'func_call'. The initialization
procedure (op 3) is called with the actual parameters and is assumed to
return a list of the actual parameters and actual local values. The list
elements correspond to the formal parameters and locals (op 2).

Newly created domains are remembered by the constructor. If a domain with
the same parameters is to be constructed the existing domain is returned.

Only some basic entries which are needed anyway are created for the domain.
If later on any other entry is needed it's created on the fly by the method
'getEntry'.

The entries created with 'func_call' are: 'name', 'domattr', 'constructor',
'constructor_args', 'super_domains', 'categories' and 'axioms'.
'constructor' ist the domain constructor for the domain, 'constructor_args'
are the actual parameters used to construct the domain (a list). 'name' is
the name of the domain instance (a string). 'domattr' always has the value
'DomainConstructor::getEntry', this entry is used to create domain entries
on the fly. 'super_domains' is a list of all super-domains, 'categories' a
list of all categories and 'axioms' a set of all axioms of the domain.

If a domain entry is evaluated (via 'domattr' or '::') and not already
created by the constructor, the entry is looked up by 'getEntry' in the
entry table (op 7 of the constructor). If there is an entry defined in the
constructor, this will be used to create the entry of the domain. If there
is no entry in the domain constructor the super-domains of the domain and
then, if the super-domains can't define the entry, the categories of the
domain will be asked to create the entry.

If an entry is found, the actual parameters and the domain instance are
substituted for the formal parameters of the constructor and the special
ident 'this' resp.  Then the entry is evaluated and the result is inserted
into the domain.  (The evaluation is done in order to allow for conditional
creation of entries for example: One may use an if-statement to define an
entry of a domain constructor.)

The super-domains of a domain are created by the method 'func_call' when the
domain is created. The 4th op of the constructor contains an expression
where the actual parameters are substituted into. The expression in then
evaluated, it is suspected to return the super-domain or NIL as result of
the evaluation.

If a super-domain exists that domain is queried for the entry by the method
'DomainConstructor::getSuperDomainEntry'. This methods searches in the
super-domain and - if necessary - the super-domains of the super-domain for
the entry. If the entry is found it is changed into an entry for the actual
domain by substituting the the actual parameters of the super-domain and the
actual domain for the formal parameters of the super-domains constructor and
'this'.

Note that the super-domains don't query their categories to create the
entry! If the actual domain at hand is in a sub-category of the categories
of the super-domain such an category entry would overwrite an entry
definition in the sub-category, causing a loss of information. (The more
specific entry in the sub-category would be hidden by the entry in the
super-category.)

If the super-domains do not define the entry the categories of the domain are
asked to create the entry. The categories of the domain are also created
when the domain is created and stored in the entry 'categories'. The 5th op
of the constructor contains a list of expressions where the actual
parameters are substituted into. The expressions are then evaluated, it is
suspected to return a list of categories as result of the evaluation.

A domain may be queried for certain categories or axioms by the method
'hasProp'. The axioms of a domain are created when the domain is created and
stored in the entry 'axioms'.

Some procedures must have strange parameter and variable names because these
names may otherwise conflict with names evaluated by the constructor (via
'eval').
++#

proc()
    local path;
begin

DomainConstructor:= domain():
DomainConstructor::name:= "DomainConstructor":
DomainConstructor::info:=
    "Domain 'DomainConstructor'":
DomainConstructor::interface:= {}:
DomainConstructor::subs:= fun(args(1)):

path := pathname("DOMAINS", "CONSTR");

DomainConstructor::allDomainEntries:= loadproc(DomainConstructor::allDomainEntries, path, "DCDomEnt");
DomainConstructor::getSuperDomainEntry:= loadproc(DomainConstructor::getSuperDomainEntry, path, "DCSDEnt");
DomainConstructor::allEntries:= loadproc(DomainConstructor::allEntries, path, "DCallEnt");
DomainConstructor::allSuperDomainEntries:= loadproc(DomainConstructor::allSuperDomainEntries, path, "DCallSDE");
DomainConstructor::axioms:= loadproc(DomainConstructor::axioms, path, "DCaxioms");
DomainConstructor::categories:= loadproc(DomainConstructor::categories, path, "DCcateg");
DomainConstructor::func_call:= loadproc(DomainConstructor::func_call, path, "DCfcall");
DomainConstructor::getEntry:= loadproc(DomainConstructor::getEntry, path, "DCgetEnt");
DomainConstructor::hasProp:= loadproc(DomainConstructor::hasProp, path, "DChasPro");
DomainConstructor::makeEntry:= loadproc(DomainConstructor::makeEntry, path, "DCmkEnt");
DomainConstructor::new:= loadproc(DomainConstructor::new, path, "DCnew");
DomainConstructor::print:= loadproc(DomainConstructor::print, path, "DCprint");
DomainConstructor::subsArgs:= loadproc(DomainConstructor::subsArgs, path, "DCsubsA");
DomainConstructor::TeX:= loadproc(DomainConstructor::TeX, path, "DCtex");
DomainConstructor::undefinedEntries:= loadproc(DomainConstructor::undefinedEntries, path, "DCundEnt");
DomainConstructor::whichEntry:= loadproc(DomainConstructor::whichEntry, path, "DCwhEnt");
DomainConstructor::testtype:= loadproc(DomainConstructor::testtype, path, "DCttype");
# DomainConstructor::add:= loadproc(DomainConstructor::add, path, "DCadd"); #

end_proc():

# end of file #
