# $Date: 1995/06/28 09:10:59 $ $Author: kg $ $Revision: 1.3.2.1 $ #

#++
TeX -- returns string with domain constructor in (La)TeX format

TeX(D)

D - domain or domain constructor
++#

DomainConstructor::TeX:= proc(DC)
    local str, e, l, texstr;
begin
    if domtype(DC) <> DomainConstructor then
        DC:= DC::constructor;
        if DC = FAIL then error("no constructor") end_if
    end_if;

    texstr:= proc(x) begin
        if x = "" then "" else
            _concat(op(subs(text2list(x,["_"]), "_"="\\_")))
        end_if
    end_proc;

    # header #
    str:= "\n\\begin{muDomain}{".expr2text(extop(DC,1)).
          "}{% short description\n}\n\n";

    # syntax #
    if nops(extop(DC,2)) = 0 then
        str:= str."\\muConstSyntax{}\n\n";
    else
        str:= str."\\muSyntax{".texstr(expr2text(op(extop(DC,2))))."}\n\n";
    end_if;

    # super-domain #
    str:= str."\\muSuperDomain{".texstr(expr2text(extop(DC,4)))."}\n\n";

    # categories #
    str:= str."\\muCategories{".texstr(expr2text(op(extop(DC,5))))."}\n\n";

    # axioms #
    str:= str."\\muAxioms{".texstr(expr2text(op(extop(DC,6)))).
                "}\n\n% domain description\n\n";

    # entries #
    l:= sort(map([ op(extop(DC,7)) ], op, 1));
    if nops(l) > 0 then
        str:= str."\\begin{muMethods}\n\n";
        for e in l do
            str:= str."\\muMethod{".texstr(e).
                    "}{% arguments\n}{% method desription\n}\n";
        end_for;
        str:= str."\n\\end{muMethods}\n\n";
    end_if;

    str."\\end{muDomain}\n\n";
end_proc:

# end of file #
