# $Date: 1995/06/28 09:10:55 $ $Author: kg $ $Revision: 1.9.2.1 $ #

#++
new -- create new domain constructor

new(name, params, locals, precomp, super_domain, categories, axioms, entry...)

name         - name of constructor (expression)
params       - list of formal parameters (list of ident's)
locals       - list of local variables (list of ident's)
precomp      - expression to test actual parameters and compute locals
super_domain - expression used to compute the super-domain
categories   - list of expressions used to compute the categories
axioms       - list of expressions used to compute the axioms
entry...     - expressions to define domain entries (equations)

The arg's are not evaluated. Later on, when a new domain is to be
constructed via 'func_call', the actual parameters and locals of the
domain and the domain itself are substituted for the formal parameters
resp. the ident 'this' in the expressions given by 'super_domain'...'entry...'.
After the substitution these expressions are evaluated.
++#

DomainConstructor::new:= proc(nam, params, locals)
    option hold;
begin
    if testargs() then
        if args(0) < 7 then error("wrong no of args") end_if;

        # the parameters and locals must be ident's #
	if not testtype(params, Type::ListOfIdents()) then
            error("invalid parameter list")
        end_if;
	if not testtype(locals, Type::ListOfIdents()) then
            error("invalid local variables list")
        end_if;

        # categories and axioms must be given by lists #
        if domtype(args(6)) <> DOM_LIST then
            error("illegal categories list")
        end_if;
        if domtype(args(7)) <> DOM_LIST then
            error("illegal axioms list")
        end_if;

        # only equation are allowed for the entries #
        if args(0) > 7 then
            if map({args(i) $ hold(i)=8..args(0)}, type) <> { "_equal" } then
                error("wrong entry list")
            end_if;
        end_if;
    end_if;

    # create domain element, converting name into string #
    new(DomainConstructor, nam, params.locals,
        subsop(proc() begin X; Y end_proc,
            1=op(params), 2=op(locals),
            [4,1]=args(4), [4,2]=params.locals, 6=nam),
        args(5), args(6), args(7),
        table(args(i) $ hold(i)=8..args(0)), domain(), nops(params));
end_proc:

# end of file #
