# $Date: 1995/06/28 09:10:54 $ $Author: kg $ $Revision: 1.9.2.1 $ #

#++
func_call -- create new domain using constructor

func_call(DC, a1,...)

DC     - domain constructor
a1,... - actual parameters of the domain to construct

Creates a domain with actual parameters ai. Only entries for the
constructor, the actual param's and constructor locals, the
name, the super-domains, the axioms and the categories are inserted
into the domain. Other entries are created on the fly using
'DomainConstructor::getEntry'. The new domain is returned.

One can't remember the existing domains with 'option remember'
because of the implicit 'option hold' of func_call. (n:=7:
Z7:=IntegerMod(n): Z7::_plus: bool(Z7=IntegerMod(7)); would
result in FALSE.)
++#

DomainConstructor::func_call:= proc(_0_DC)
    local this, _0_call, _0_C, _0_c, _0_S, _0_A;
begin
    # 'func_call' has option hold implicitly #
    _0_DC:= context(_0_DC);
    _0_call:= context([args(i) $ hold(i)=2..args(0)]);

    # test arguments #
    if testargs() then
        if args(0) = 0 then error("wrong no of args") end_if;
        if domtype(_0_DC) <> DomainConstructor then
            error("no domain constructor")
        end_if;
    end_if;

    # create domain #
    this:= domain();
    this::constructor:= _0_DC;

    # compute actual values of locals #
    _0_call:= extop(_0_DC,3)(op(_0_call));
    if domtype(_0_call) <> DOM_LIST then
        error("invalid constructor")
    end_if;
    if nops(_0_call) <> nops(extop(_0_DC,2)) then
        error("invalid constructor")
    end_if;

    # does the domain already exist? #
    if domattr(extop(_0_DC,8), _0_call) <> FAIL then 
        return(domattr(extop(_0_DC,8), _0_call))
    end_if;

    # add name #
    if extop(_0_DC,9) = 0 then
        this::name:= extop(_0_DC,1)
    else
        this::name:= subsop(hold(f)(op(_0_call, 1..extop(_0_DC,9))),
        		    0=extop(_0_DC,1))
    end_if;

    this::constructor_args:= _0_call;
    this::super_domains:= [];
    this::categories:= [];
    this::axioms:= {};
    this::domattr:= DomainConstructor::getEntry;

    # list super-domains #
    _0_S:= this;
    while extop(_0_S::constructor,4) <> NIL do
	_0_S:= DomainConstructor::subsArgs(extop(_0_S::constructor,4), this, this);
	if domtype(_0_S) <> DOM_DOMAIN then
	    error("invalid super-domain")
	end_if;
	this::super_domains:= append(this::super_domains, _0_S)
    end_while;

    # list direct axioms #
    this::axioms:= { op(map(extop(_0_DC,6),
			    DomainConstructor::subsArgs, this, this)) }
		   minus {NIL};
    if this::axioms <> {} then
	if map(this::axioms, domtype) <> {Axiom} then
	    error("invalid axiom")
	end_if
    end_if;

    # list direct categories and their axioms #
    for _0_C in extop(_0_DC,5) do
	# make category #
	_0_C:= DomainConstructor::subsArgs(_0_C, this, this);
	if _0_C = hold(_0_C) then next end_if;
	if contains(this::categories, _0_C) <> 0 then next end_if;
	if domtype(_0_C) <> Category then
	    error("invalid category")
	end_if;
	this::categories:= append(this::categories, _0_C);
	# make axioms #
	_0_A:= { op(map(extop(extop(_0_C,1),5),
		        CategoryConstructor::subsArgs, _0_C, this)) }
	       minus { NIL };
	if _0_A <> {} then
	    if map(_0_A, domtype) <> {Axiom} then
		error("invalid axiom")
	    end_if;
	    this::axioms:= this::axioms union _0_A;
	end_if;
    end_for;

    # list super-categories and their axioms #
    # categories are added by searching the categories graph breadth-first #
    _0_c:= 1;
    while _0_c <= nops(this::categories) do
	_0_S:= this::categories[_0_c];
	for _0_C in extop(extop(_0_S,1),4) do
	    # make super-category #
	    _0_C:= CategoryConstructor::subsArgs(_0_C, _0_S, this);
	    if _0_C = hold(_0_C) then next end_if;
	    if contains(this::categories, _0_C) <> 0 then next end_if;
	    if domtype(_0_C) <> Category then
		error("invalid category")
	    end_if;
	    this::categories:= append(this::categories, _0_C);
	    # make axioms #
	    _0_A:= { op(map(extop(extop(_0_C,1),5),
			    CategoryConstructor::subsArgs, _0_C, this)) }
		   minus { NIL };
	    if _0_A <> {} then
		if map(_0_A, domtype) <> {Axiom} then
		    error("invalid axiom")
		end_if;
		this::axioms:= this::axioms union _0_A;
	    end_if;
	end_for;
	_0_c:= _0_c+1;
    end_while;

    # remember domain #
    domattr(extop(_0_DC,8), _0_call):= this;
    this
end_proc:

# end of file #
