# $Date: 1995/05/19 06:51:34 $ $Author: kg $ $Revision: 1.2 $ #

# kg, 28/04/95 #

#++
add -- add entrys to domain constructor

add(DC, entry...)

DC       - domain constructor or domain
entry... - expressions to define domain entries (equations)

Adds entries to the constructor DC, returns a new constructor.

The entry's are not evaluated. Later on, when a new domain entry is to be
constructed, the actual parameters and locals of the domain and the domain
itself are substituted for the formal parameters resp. the ident 'this' in
the expressions given by 'entry...'. After the substitution these
expressions are evaluated.
++#

DomainConstructor::add:= proc(DC)
    option hold;
    local i, t;
begin
    if args(0) < 2 then error("wrong no of args") end_if;
    DC:= context(DC);
    if testargs() then
        case domtype(DC)
        of DomainConstructor do
            break;
        of DOM_DOMAIN do
            if DC::constructor <> FAIL then
                DC:= DC::constructor;
                if domtype(DC) <> DomainConstructor then
                    error("illegal domain")
                end_if;
                break;
            end_if;
        otherwise error("no domain constructor");
        end_case;
        # only equation are allowed for the entries #
        if map({args(i) $ hold(i)=2..args(0)}, type) <> { "_equal" } then
            error("wrong entry")
        end_if;
    end_if;

    t:= extop(DC,7);
    for i from 2 to args(0) do
        t[op(args(i),1)]:= op(args(i),2)
    end_for;
    extsubsop(DC, 7=t);
end_proc:

# end of file #
