# $Date: 1995/05/19 06:51:33 $ $Author: kg $ $Revision: 1.15 $ #
#++
CategoryConstructor -- the domain of category constructors

A category constructors is used to create categories depending upon
parameters.

Normally only the method 'new' of the domain 'CategoryConstructor' is
called by the category constructor implementor. The other methods are
called implicitly.

A category constructor is an element of CategoryConstructor with the
following operands:

0 - the domain CategoryConstructor
1 - the name of the constructor (a string)
2 - the formal parameters and local variables of the constructor
    (a list of ident's)
3 - a procedure testing the actual parameters and computing the locals
4 - a list of expressions which must evaluate to categories
5 - a list of expressions which must evaluate to axioms
6 - a table with the entries for the categories to construct
7 - a domain containing the domains constructed so far
8 - the number of formal parameters

New domain constructors are created by the method 'new'. I'm very careful not
to evaluate the arg's of 'new' - they will be evaluated when domain entries
are to be created later on.

Category instances are created by the method 'func_call'. The initialization
procedure (op 3) is called with the actual parameters and is assumed to
return a list of the actual parameters and actual local values. The list
elements correspond to the formal parameters and locals (op 2).

Newly created categories are remembered by the constructor. If a category
with the same parameters is to be constructed the existing category is
returned.

When a new domain is created all the categories and axioms of the domain are
created too, depending on the actual parameters of the category. To create
the direct super-categories of a category the 4th op of the category
constructor contains an expression where the actual parameters are
substituted into. The expression in then evaluated, it is suspected to
return a list of super-categories as result of the evaluation.

If a domain entry is evaluated (via 'domattr' or '::') which is not already
created by the domain constructor, the entry is looked up by the domain
constructor. If there is no entry in the domain constructor the categories
of the domain will be asked to create the entry via
'CategoryConstructor::getEntry'.

The categories in turn ask their constructors to create the entry using the
actual category constructor parameters. If the constructor has a definition
for the entry, this entry is changed into a domain entry and returned as
result of the look-up: The actual category parameters and the domain
instance is substituted for the formal category parameters and the special
ident 'this' resp. Then the entry is evaluated and returned.

Some procedures must have strange parameter and variable names because these
names may otherwise conflict with names evaluated by the constructor (via
'eval').
++#

proc()
    local path;
begin

CategoryConstructor:= domain():
CategoryConstructor::name:= "CategoryConstructor":
CategoryConstructor::info:= "Domain: 'CategoryConstructor'":
CategoryConstructor::interface:= {}:
CategoryConstructor::subs:= fun(args(1)):

path := pathname("DOMAINS", "CONSTR");

CategoryConstructor::getNamedEntry:= loadproc(CategoryConstructor::getNamedEntry, path, "CCNamEnt");
CategoryConstructor::allEntries:= loadproc(CategoryConstructor::allEntries, path, "CCallEnt");
CategoryConstructor::func_call:= loadproc(CategoryConstructor::func_call, path, "CCfcall");
CategoryConstructor::getEntry:= loadproc(CategoryConstructor::getEntry, path, "CCgetEnt");
CategoryConstructor::new:= loadproc(CategoryConstructor::new, path, "CCnew");
CategoryConstructor::print:= loadproc(CategoryConstructor::print, path, "CCprint");
CategoryConstructor::subsArgs:= loadproc(CategoryConstructor::subsArgs, path, "CCsubArg");
CategoryConstructor::testtype:= loadproc(CategoryConstructor::testtype, path, "CCttype");
CategoryConstructor::TeX:= loadproc(CategoryConstructor::TeX, path, "CCtex");
# CategoryConstructor::add:= loadproc(CategoryConstructor::add, path, "CCadd"); #

end_proc():

# end of file #
