# $Date: 1995/06/28 09:10:50 $ $Author: kg $ $Revision: 1.3.2.1 $ #

#++
TeX -- returns string with category constructor in (La)TeX format

TeX(CC)

CC - category or category constructor
++#

CategoryConstructor::TeX:= proc(CC)
    local str, e, lb, lm, texstr;
begin
    if domtype(CC) <> CategoryConstructor then
        if domtype(CC) <> Category then
            error("no constructor")
        end_if;
        CC:= extop(CC,1);
    end_if;

    texstr:= proc(x) begin
        if x = "" then "" else
            _concat(op(subs(text2list(x,["_"]), "_"="\\_")))
        end_if
    end_proc;

    # header #
    str:= "\n\\begin{muCategory}{".expr2text(extop(CC,1)).
          "}{% short description\n}\n\n";

    # syntax #
    if nops(extop(CC,2)) = 0 then
        str:= str."\\muConstSyntax{}\n\n";
    else
        str:= str."\\muSyntax{".texstr(expr2text(op(extop(CC,2))))."}\n\n";
    end_if;

    # super-categories #
    str:= str."\\muCategories{".texstr(expr2text(op(extop(CC,4))))."}\n\n";

    # axioms #
    str:= str."\\muAxioms{".texstr(expr2text(op(extop(CC,5)))).
                "}\n\n% domain description\n\n";

    # entries #
    lb:= []; lm:= [];
    for e in extop(CC,6) do
        if op(e,2) = hold(toBeDefined) then
            lb:= append(lb, op(e,1));
        else
            lm:= append(lm, op(e,1));
        end_if
    end_for;

    if nops(lb) > 0 then
        str:= str."\\begin{muBaseMethods}\n\n";
        for e in sort(lb) do
            str:= str."\\muMethod{".texstr(e).
                "}{% arguments\n}{% method desription\n}\n";
        end_for;
        str:= str."\n\\end{muBaseMethods}\n\n";
    end_if;

    if nops(lm) > 0 then
        str:= str."\\begin{muMethods}\n\n";
        for e in sort(lm) do
            str:= str."\\muMethod{".texstr(e).
                "}{% arguments\n}{% method desription\n}\n";
        end_for;
        str:= str."\n\\end{muMethods}\n\n";
    end_if;

    str."\\end{muCategory}\n\n";
end_proc:

# end of file #
