# $Date: 1995/06/28 09:10:43 $ $Author: kg $ $Revision: 1.8.2.1 $
#
#++
Axiom -- the domain of axioms

Axioms are - up to now - only a device to attach attributes to domains
and categories.  An axiom is an element of the domain 'Axiom'. Axioms
may depend upon parameters and are created by axiom constructors
(elements of the domain 'AxiomConstructor').

An axiom has the following operands:

0    - the domain 'Axiom'
1    - the axiom constructor
2    - the number of formal parameters of the axiom
3..n - the actual parameters and actual locals of the axiom

None of the methods defined here are normally called directly by the
category implementor or user. They are called implizitly.
++#

Axiom:= domain():
Axiom::name:= "Axiom":
Axiom::info:= "Domain 'Axiom'":
Axiom::interface:= {}:
Axiom::subs:= fun(args(1)):

#++
new -- create a new Axiom using constructor

new(AC,n,a1,...)

AC     - axiom constructor
n      - number of actual parameters
a1,... - actual axiom parameters and locals (may be empty)
++#

Axiom::new:= fun((
    if testargs() then
	if args(0) < 2 then error("wrong no of args") end_if;
	if domtype(args(1)) <> AxiomConstructor then
	    error("no axiom constructor")
	end_if;
	if domtype(args(2)) <> DOM_INT then
	    error("no parameter count");
	end_if;
	if args(2) < 0 then
	    error("illegal parameter count");
	end_if;
    end_if;

    new(Axiom, args())
)):


#++
print -- print Axiom

print(A)

A - axiom
++#

Axiom::print:= fun((
    if testargs() then
	if args(0) <> 1 then error("wrong no of args") end_if;
	if domtype(args(1)) <> Axiom then
	    error("no axiom")
	end_if;
    end_if;

    if extop(args(1),2) = 0 then
	extop(extop(args(1),1), 1)
    else
	extop(extop(args(1),1), 1)
	    (extop(args(1),i) $ hold(i)=3..(2+extop(args(1),2)))
    end_if
)):


#++
TeX -- return TeX-formatted string

TeX(A)

A - axiom
++#

Axiom::TeX:= fun(TeX(Axiom::print(args(1)))):


#++
testtype -- test type of axiom

testtype(e, T)

e - expression
T - type

Returns TRUE if e is an Axiom and T is Axiom and FAIL otherwise.
++#

Axiom::testtype:= fun((
    if args(2) = Axiom then
	if domtype(args(1)) = Axiom then
	    return(TRUE)
	end_if
    end_if;
    FAIL
)):

#++
constructor -- return constructor of Axiom

constructor(A)

A - axiom
++#

Axiom::constructor:= fun((
    if testargs() then
	if args(0) <> 1 then error("wrong no of args") end_if;
	if domtype(args(1)) <> Axiom then
	    error("no axiom")
	end_if;
    end_if;
    extop(args(1),1)
)):

# end of file #
