# $Date: 1995/04/26 18:23:00 $ $Author: kg $ $Revision: 1.11 $
#
#++
AxiomConstructor -- the domain of axiom constructors

Axiom constructors are used to create axioms depending upon
parameters.  (Axioms are elements of the domain 'Axiom'.)

Normally only the method 'new' of the domain 'AxiomConstructor' is
called by the axiom constructor implementor. The other methods are
called implicitly.

An axiom constructor is an element of AxiomConstructor with the
following operands:

0 - the domain AxiomConstructor
1 - the name of the constructor (a string)
2 - the formal parameters and local variables of the constructor
    (a list of ident's)
3 - a procedure testing the actual parameters and computing the locals
4 - a domain containing the axioms constructed so far
5 - the number of formal parameters

New axiom constructors are created by the method 'new'. I'm very
careful not to evaluate the arg's of 'new' - they will be evaluated
when a axiom instance is created later on.

Axiom instances are created by the method 'func_call'. The initialization
procedure (op 3) is called with the actual parameters and is assumed to
return a list of the actual parameters and actual local values. The list
elements correspond to the formal parameters and locals (op 2).
++#

proc()
    local path;
begin

AxiomConstructor:= domain():
AxiomConstructor::name:= "AxiomConstructor":
AxiomConstructor::info:=
	"Domain 'AxiomConstructor'":
AxiomConstructor::interface:= {}:
AxiomConstructor::subs:= fun(args(1)):

path := pathname("DOMAINS", "CONSTR");

AxiomConstructor::func_call:= loadproc(AxiomConstructor::func_call, path, "ACfcall");
AxiomConstructor::new:= loadproc(AxiomConstructor::new, path, "ACnew");
AxiomConstructor::print:= loadproc(AxiomConstructor::print, path, "ACprint");
AxiomConstructor::testtype:= loadproc(AxiomConstructor::testtype, path, "ACttype");
AxiomConstructor::TeX:= loadproc(AxiomConstructor::TeX, path, "ACtex");

end_proc():

# end of file #

