# $Date: 1995/06/28 09:53:56 $ $Author: kg $ $Revision: 1.11.2.1 $ #
#++
SetCat -- the category of sets

The SetCat is the base category, any category is a SetCat.
In a SetCat it can be decided if domain elements are equal.
Note that this not necessarily means 'mathematically equal', it
may only mean 'structurally equal'.

The MuPAD expressions (x^2-1)/(x+1) and x-1 are mathematically equal,
but not structurally, for example.

Use the axiom canonicalRep to state that elements of a domain are
canonically represented by MuPAD expressions, ie. that structural
equality is the same as mathematical equality.

Basic Methods:
equal(x,y)      - returns TRUE iff x and y are equal where x and y are from
		  'this' domain
convert(e,...)  - converts its arguments to an element of 'this' or returns
		  FAIL if this is not possible
convert_to(x,T) - converts x (an element of 'this') to type T or returns
		  FAIL if this is not possible
expr(x)		- converts x (an element of 'this') to an expression
random()	- returns a random element of 'this'

Methods:
new(e,...)    - converts its arguments to an element of 'this'
print(e)      - returns an expression which is printed as domain element e
		plus probably some type information
printElem(e)  - returns an expression which is printed as domain element e
testtype(e,T) - tests if e is an element of type T
equiv(x,y)    - returns TRUE iff x and y are equivalent, x or y must
		be of this domain
++#

SetCat:= CategoryConstructor(
    SetCat,
    [],
    [],
    NIL,
    [],
    [],

    "convert", "convert_to", "expr", "random", "equal",

    "print" = fun((
        if domains::SHOW_TYPE then
            (this::printElem(args(1)), this)
        else
            this::printElem(args(1))
        end_if
    )),
    
    "printElem" = this::expr,

    "new" = fun((
        this::convert(args());
        if % = FAIL then error("illegal arguments") else % end_if
    )),

    "testtype" = fun(( #e,T#
	# if T is an element of 'this' than e has type T iff e == T #
        if domtype(args(2)) = this then
	    return(this::equiv(args(1), args(2)))
	end_if;

	case domtype(args(1))
	    # e is an element of domain T #
	of args(2) do return(TRUE);
	of this do
	    # e is an element of 'this' and can be converted to T #
            if this::convert_to(args(1), args(2)) <> FAIL then return(TRUE) end_if;
	    break;
	otherwise
	    # T is 'this' and can convert e to an element of its own #
            if this::convert(args(1)) <> FAIL then return(TRUE) end_if;
	end_case;
        FAIL
    )),

    "equiv" = proc(x,y) begin
	if domtype(x) = this then
	    if domtype(y) = this then
		return(this::equal(x,y))
	    end_if;
	    y:= this::convert(y);
	else
	    x:= this::convert(x);
	    if domtype(y) <> this then
		y:= this::convert(y);
	    end_if
	end_if;
	if x = FAIL or y = FAIL then FAIL else this::equal(x,y) end_if
    end_proc

)():

