# $Date: 1995/05/17 08:44:21 $ $Author: kg $ $Revision: 1.5 $ #
#++
Module -- the category of R-modules

Module(R)

R - a CommutativeRing

A Module is a LeftModule and a RightModule over a commutative
ring R, thus the multiplication '*' must have two signatures
'*' : (this,R) -> this and '*' : (R,this) -> this.

Beware: If a SemiGroup is also a Module the multiplication '*'
has even more signatures: '*' : (this,this) -> this.
The implementation of the multiplication must handle this. The same
kind of problem is occuring if a domain is a Module over more
than one rng.

Methods:-
_mult(x,r) - returns the multiplikation x*r of x by the rng element r
_mult(r,x) - returns the multiplikation r*x of x by the rng element r
++#

Module:= CategoryConstructor(
    Module,
    [ R ],
    [],
    (if args(0) <> 1 then error("wrong no of args") end_if;
     if not R::hasProp(CommutativeRing) then
	 error("no commutative ring")
     end_if),

    [ LeftModule(R), RightModule(R) ],
    []

):

