# $Date: 1995/05/26 07:58:29 $ $Author: kg $ $Revision: 1.9 $ #
#++
HomogeneousFiniteProductCat -- the category of homogeneous finite products

HomogeneousFiniteProductCat(Dom)

A homogeneous finite product is a homogeneous finite collection where each
element has the same number of elements.

Entries:-
card - the number of elements in the product
++#

HomogeneousFiniteProductCat:= CategoryConstructor(
    HomogeneousFiniteProductCat,
    [ Dom ],
    [ ],
    ( if args(0) <> 1 then error("wrong no of args") end_if;
      if Dom::hasProp(SetCat) <> TRUE then error("not a set") end_if ),
    [ # a product is a module over each rng for which the components are one #
      (if   Dom::hasProp(DifferentialRing) then DifferentialRing
       elif Dom::hasProp(PartialDifferentialRing) then PartialDifferentialRing
       elif Dom::hasProp(CommutativeRing) then CommutativeRing
       elif Dom::hasProp(Ring) then Ring
       elif Dom::hasProp(Rng) then Rng 
       elif Dom::hasProp(AbelianGroup) then AbelianGroup
       elif Dom::hasProp(CancellationAbelianMonoid) then CancellationAbelianMonoid
       elif Dom::hasProp(AbelianMonoid) then AbelianMonoid
       elif Dom::hasProp(AbelianSemiGroup) then AbelianSemiGroup
       end_if),       
      (if   Dom::hasProp(SkewField) then SkewField end_if),
      (if   Dom::hasProp(Group) then Group
       elif Dom::hasProp(Monoid) then Monoid
       elif Dom::hasProp(SemiGroup) then SemiGroup
       end_if),
      (if Dom::hasProp(CommutativeRing) then
      	   Algebra(Dom)
       elif Dom::hasProp(Ring) then
      	   (LeftModule(Dom), RightModule(Dom))
       end_if),
       HomogeneousFiniteCollectionCat(Dom) ],
    [ ],
    
    "card",
    
    "nops" = this::card,
    
    "characteristic" = (if Dom::hasProp(Ring) then Dom::characteristic end_if)
    
    # One could principally implement all the algebraic operations here, but they
      will be slow if _index and set_index are slow, which most often will be the
      case. So we avoid the work and let the domain implementors do it... #

):

