# $Date: 1995/05/17 08:44:07 $ $Author: kg $ $Revision: 1.7 $
#
#++
FactorialDomain -- the category of factorial domains (unique factorisation
		   domains)

The method Factor is defined to avoid an inconsistency: An Integer
is represented as DOM_INT and factored by 'ifactor'. If 'factor' is
called with an integer it returns that integer unfactored (assuming it
is a trivial polynomial). So the method this::Factor is to be used to
get a factorization for any factorial domain.

The method factor is only defined in order to allow the overloading
of the function 'factor' if the elements of this domain are represented
explizitly.

The same arguments hold for the methods sqrFree and sqrfree.

Methods:
isPrime(x) - returns TRUE iff x is prime
sqrFree(x) - returns the square-free factorisation of x in form
	     of a list [u, f1, e1, ... ,fn, en] where u is a unit and fi are
	     square-free factors with exponents ei, ie.
	     x = u * f1^e1 * ... * fn^en.
Factor(x)  - returns the factorisation of x in form of a list
             [u, f1, e1, ... ,fn, en] where u is a unit and fi are
	     irreducible elements with exponents ei, ie.
	     x = u * f1^e1 * ... * fn^en.
factor(x)  - returns this::Factor(x)
sqrfree(x) - returns this::sqrFree(x)
++#

FactorialDomain:= CategoryConstructor(
    FactorialDomain,
    [],
    [],
    NIL,
    [ GcdDomain ],
    [],

    "Factor",

    "sqrFree" = proc(x) local i, j, f, e; begin
	x:= this::Factor(x);
	f:= table();
	for i from 3 to nops(x) step 2 do
	    if contains(f, x[i]) then
		f[x[i]]:= this::_mult(f[x[i]], x[i-1])
	    else
		f[x[i]]:= x[i-1]
	    end_if;
	end_for;
	e:= sort(map([op(f)], op, 1));
	[x[1], (f[e[j]], e[j]) $ j=1..nops(e) ]
    end_proc,

    "isPrime" = proc(x) begin
	x:= this::Factor(x);
	if nops(x) = 3 then
	    if x[3] = 1 then
		return(TRUE)
	    end_if
	end_if;
	FALSE
    end_proc,

    "factor" = this::Factor,

    "sqrfree" = this::sqrFree

)():

