# $Date: 1995/07/17 09:36:29 $ $Author: kg $ $Revision: 1.6.2.1 $ #
#++
EuclideanDomain -- the category of euclidean domains

An EuclideanDomain is an principal ideal domain with an 'Euclidean degree'
function and operations "quo" and "rem" computing the Euclidean quotient
and the Euclidean reminder resp.

Methods:
euclideanDegree(x) - returns the Euclidean degree of x, a non-negative integer
quo(x,y)	   - returns the Euclidean quotient of x and y
rem(x,y)	   - returns the Euclidean reminder of x and y
divide(x,y)	   - returns the sequence quo(x,y),rem(x,y)
gcdex(x,y)	   - returns (g, v, w) such that g = gcd(x,y) = x*v + y*w

The euclideanDegree returns non-negative integers such that for each x, y <> 0

	x = quo(x,y) * y + rem(x,y)

and euclideanDegree(rem(x,y)) < euclideanDegree(y).

The gcd is computed by the Euclidean algorithm. The gcdex is computed by the
extended Euclidean algorithm.
++#

EuclideanDomain:= CategoryConstructor(
    EuclideanDomain,
    [],
    [],
    NIL,
    [ PrincipalIdealDomain ],
    [],

    "euclideanDegree", "divide",

    "quo" = proc(x,y) begin this::divide(x,y)[1] end_proc,

    "rem" = proc(x,y) begin this::divide(x,y)[2] end_proc,

    "divex" = proc(x,y) begin
	x:= this::divide(x,y);
	if this::iszero(x[2]) then x[1] else FAIL end_if;
    end_proc,

    "gcd" = proc(x, y)
	local l, i, g;
    begin
	if args(0) > 2 then
	    l:= sort([ args() ],
		     proc(a,b)
		     begin
			 bool(this::euclideanDegree(a) <
			      this::euclideanDegree(b))
		     end_proc);
	    g:= this::gcd(l[1], l[2]);
	    for i from 3 to args(0) do
		g:= this::gcd(g, l[i])
	    end_for
	else
	    x:= this::unitNormal(x);
	    y:= this::unitNormal(y);

	    while not this::iszero(y) do
		this::rem(x, y); x:= y; y:= %2
	    end_while;

	    this::unitNormal(x)
	end_if
    end_proc,

    "gcdex" = proc(x, y)
	local x1, x2, y1, y2, q, uc, ux, uy;
    begin
	x:= this::unitNormalRep(x); ux:= x[2]; x:= x[1];
	y:= this::unitNormalRep(y); uy:= y[2]; y:= y[1];

	x1:= this::one; x2:= this::zero;
	y1:= this::zero; y2:= this::one;

	while not this::iszero(y) do
	    q:= this::negate(this::quo(x, y));

	    this::_plus(x, this::_mult(q, y));
	    x:= y; y:= %2;
	    this::_plus(x1, this::_mult(q, y1));
	    x1:= y1; y1:= %2;
	    this::_plus(x2, this::_mult(q, y2));
	    x2:= y2; y2:= %2;
	end_while;

	x:= this::unitNormalRep(x); uc:= x[2];

	( x[1], this::_mult(x1, uc, ux), this::_mult(x2, uc, uy) )
    end_proc,
    
    "idealGenerator" = this::gcd

)():
