# $Date: 1995/05/17 08:43:55 $ $Author: kg $ $Revision: 1.9 $ #
#++
AbelianMonoid -- the category of abelian monoids

An AbelianMonoid is a AbelianSemiGroup with a neutral element "zero"
according to the operation '+'.

Use axiom 'normalRep' to state that "zero" is always represented
canonically.

If a domain has not the axion 'normalRep' then "zero" is only one
possible representation of the neutral element. Use "iszero" to
test for 0 in such a case.

Entries:-
zero         - the neutral Element according to '_plus'

Methods:-
iszero(x)    - returns TRUE iff x is zero
intmult(x,i) - returns x+x+...+x (i times) for a positive integer i and
	       zero for i=0
++#

AbelianMonoid:= CategoryConstructor(
    AbelianMonoid,
    [],
    [],
    NIL,
    [ AbelianSemiGroup ],
    [ (if this::hasProp(canonicalRep) then normalRep end_if) ],

    "zero",

    "iszero" = ( if this::hasProp(normalRep) then
	proc(x) begin bool(x = this::zero) end_proc
    else
	proc(x) begin bool(this::equal(x, this::zero)) end_proc
    end_if ),

    "intmult" = domains::repeatedSquaring(this, "_plus", "zero")

)():

